/*

			Craters  --  The Screen Saver
			
		by John Walker  --  kelvin@fourmilab.ch
		
		    Release 1.0  --  September 1994
			Release 2.0  --  April 1996
			Release 3.0  --  July 2006

*/ 

#include "craters.h"      

#define ID_TIMER 200

/* Function prototypes */

static void GetIniEntries(void);
static void GetIniSettings(void);

/* Global used by SCRNSAVE.LIB. Required for all screen savers. */

char szAppName[40];

/* Globals exported. */

char szName[]="Craters Screen Saver"; 

/* Externals defined in SCRNSAVE.LIB. Required for all screen savers. */

HINSTANCE hMainInstance;
HWND hMainWindow;
char szName[TITLEBARNAMELEN];
char szScreenSaver[22];
char szHelpFile[MAXFILELEN];
char szNoHelpMemory[BUFFLEN];
UINT MyHelpMessage;
HOOKPROC fpMessageFilter;

//	Configuration parameters

DWORD resetInterval = 0;						// Reset interval in ticks, 0 = never

static WORD wElapse = 0;						// Speed parameter
static WORD wTimer;								// Timer id
static char szResetScreen[] = "ResetScreen";	// Periodically reset screen ?
static BOOL resetScreen;						// Periodically reset screen
static char szResetInterval[] = "ResetInterval";// Reset interval in minutes
static DWORD resetMinutes;						// Reset interval in minutes
static BOOL noMem = FALSE;						// Insufficient memory detected

/* ScreenSaverProc -- Main entry point for screen saver messages.
					  This function is required for all screen savers.

	Params:  Standard window message handler parameters.

	Return:  The return value depends on the message.

	Note that all messages go to the DefScreenSaverProc(), except
	for ones we process.
*/

WindowProc(ScreenSaverProc)
{
    HDC hDC;
    RECT rc;
	PAINTSTRUCT ps;

    switch (Message) {

        case WM_CREATE:
        {
            /* Load the strings from the STRINGTABLE */

			hDC = GetDC(hWnd);
            GetIniEntries();
            GetIniSettings();
            
            resetInterval = resetScreen ? (60000L * resetMinutes) : 0;
            
            if (!craterInit(hWnd)) {
            	noMem = TRUE;
            }

            /* Create a timer to update the image */

            wTimer = SetTimer(hWnd, ID_TIMER, wElapse, NULL);
		    ReleaseDC(hWnd, hDC);
            break;
        }

        case WM_TIMER:
			hDC = GetDC(hWnd);
			if (!noMem) {
				if (!craterMake(hWnd, hDC, 100, FALSE)) {
					noMem = TRUE;
				}
			}
			
			/*  If we've run out of memory (whether during initialisation or
				during generation), switch the timer to a ten second interval
				and display a randomly-positioned out of memory message on the
				screen.  */
				 
			if (noMem) {
				char s[132];
				int tx, ty;
				SIZE sz;
				
				if (wElapse < 10000) {
					// First time.  Change timer interval to 10 seconds
					if (wTimer) {
						KillTimer(hWnd, ID_TIMER);
					}
					wElapse = 10000;
					wTimer = SetTimer(hWnd, ID_TIMER, wElapse, NULL);
					craterTerm();			// Release all memory in use
				}
	    		GetClientRect(hWnd, &rc);
	    		FillRect(hDC, &rc, (HBRUSH) GetStockObject(BLACK_BRUSH));
  				LoadString(hMainInstance, idsInsuffMemory, s, sizeof s);
	  			GetTextExtentPoint32(hDC, s, lstrlen(s), &sz);
  				SetBkMode(hDC, TRANSPARENT);
  				tx = (int) (((rc.right - sz.cx) * (random() & 32767L)) / 32767L); 
  				ty = (int) (((rc.bottom - sz.cy) * (random() & 32767L)) / 32767L); 
  				SetTextColor(hDC, RGB(255, 255, 255));
  				SetTextAlign(hDC, TA_NOUPDATECP);
  				TextOut(hDC, tx, ty, s, lstrlen(s));
			}
		    ReleaseDC(hWnd, hDC);
            break;

        case WM_DESTROY:
            if (wTimer) {
            	KillTimer(hWnd, ID_TIMER);
            }
            craterTerm();
            break;
        
        case WM_PAINT:
            memset(&ps, 0, sizeof(PAINTSTRUCT));
            hDC = BeginPaint(hWnd, &ps);
			if (!noMem) {
				if (!craterMake(hWnd, hDC, 0, TRUE)) {
					noMem = TRUE;
				}
			}
            EndPaint(hWnd, &ps);
            break;

        case WM_ERASEBKGND:
#ifdef NEEDED
			hDC = GetDC(hWnd);
			if (!noMem) {
				if (!craterMake(hWnd, hDC, 0, TRUE)) {
					noMem = TRUE;
				}
			}
		    ReleaseDC(hWnd, hDC);
#endif
        	return TRUE;			// No need, since we clear to initial terrain
        	
        case WM_COMPACTING:			// If compacting, release the stampers
        	relstamp();
        	break;
	}

    return DefScreenSaverProc(hWnd, Message, wParam, lParam);
}

/* RegisterDialogClasses -- Entry point for registering window
							classes required by configuration dialog box.

	Params:  hWnd -- Handle to window

	Return:  None
*/

BOOL WINAPI RegisterDialogClasses(HANDLE hInst)
{
    return TRUE;
}

/* ScreenSaverConfigureDialog -- Dialog box function for configuration dialog.

	Params:  hWnd -- Handle to window

	Return:  None
*/

DialogueProc(ScreenSaverConfigureDialog)
{
	static HWND hIDOK;
	static HWND hSetPassword;

    switch (message) {
        case WM_INITDIALOG:
            GetIniEntries();
            GetIniSettings();
            SendDlgItemMessage(hDlg, IDC_CH_RESET, BM_SETCHECK, resetScreen, 0);
            SetDlgItemInt(hDlg, IDC_RESET_INT, resetMinutes, FALSE);
            EnableWindow(GetDlgItem(hDlg, IDC_RESET_INT), resetScreen);  
            hIDOK = GetDlgItem(hDlg, IDOK);
            return TRUE;

        case WM_COMMAND:
            switch (wParam) {
                case IDOK:					// OK
					{
						HKEY keyh;
						DWORD dispos;
						TCHAR keyname[80];
						
						resetScreen = IsDlgButtonChecked(hDlg, IDC_CH_RESET);
						resetMinutes = GetDlgItemInt(hDlg, IDC_RESET_INT, NULL, FALSE);	

						strcpy(keyname, "Software\\Fourmilab.ch\\");
						strcat(keyname, szAppName);
						if (RegCreateKeyEx(HKEY_CURRENT_USER,
									keyname,					// Subkey name
									0,							// Reserved
									"",							// Bogus class string
									REG_OPTION_NON_VOLATILE,	// Options
									KEY_ALL_ACCESS,				// Access rights			
									NULL,						// Security attributes
									&keyh,						// Returned handle to the key
									&dispos) == ERROR_SUCCESS) { // Returned disposition
								RegSetValueEx(keyh, szResetInterval, 0, REG_DWORD, 
									(BYTE *) &resetMinutes, sizeof(resetMinutes));
								RegSetValueEx(keyh, szResetScreen, 0, REG_DWORD, 
									(BYTE *) &resetScreen, sizeof(resetScreen));
								RegCloseKey(keyh);
						}

            			resetInterval = resetScreen ? (60000L * resetMinutes) : 0;
					}
                    EndDialog(hDlg, TRUE);
                    return TRUE;

                case IDCANCEL:				// Cancel
                    EndDialog(hDlg, FALSE);
                    return TRUE;
                    
                case IDC_CH_RESET:			// Reset terrain on/off
                	EnableWindow(GetDlgItem(hDlg, IDC_RESET_INT),
                					IsDlgButtonChecked(hDlg, IDC_CH_RESET));  
                	return TRUE;
            }
            break;
    }
    return FALSE;
}

/* GetIniSettings -- Get initial settings from the registry

	Params:  hWnd -- Handle to window

	Return:  None
*/

static void GetIniSettings(void)
{
	HKEY keyh;
	TCHAR keyname[80];
	
	strcpy(keyname, "Software\\Fourmilab.ch\\");
	strcat(keyname, szAppName);

	if (RegOpenKeyEx(HKEY_CURRENT_USER,
			keyname,				// Subkey name
			0,						// Reserved
			KEY_QUERY_VALUE,		// Security access mask
			&keyh) == ERROR_SUCCESS) {
		DWORD vsize = sizeof(resetMinutes);
		DWORD vtype =  REG_DWORD;

		RegQueryValueEx(keyh, szResetInterval, NULL, &vtype, 
			(BYTE *) &resetMinutes, &vsize);
		vsize = sizeof(resetScreen);
		RegQueryValueEx(keyh, szResetScreen, NULL, &vtype, 
			(BYTE *) &resetScreen, &vsize);
		RegCloseKey(keyh);
	} else {
		resetMinutes = 10;
		resetScreen = FALSE;
	}
}

static void GetIniEntries(void)
{
  // Load Common Strings from stringtable...
  LoadString(hMainInstance, idsAppName, szAppName, 40); 
  LoadString(hMainInstance, idsScreenSaver, szScreenSaver, 22);
  LoadString(hMainInstance, idsHelpFile, szHelpFile, MAXFILELEN);
  LoadString(hMainInstance, idsNoHelpMemory, szNoHelpMemory, BUFFLEN);
}
