
    #   Read background radiation file from standard input
    #   and output histogram binned by local solar time in hours.

    $Datasel = 0;                     # Nonzero to randomly select 1/4 data set

    $Prune = 1;                       # Nonzero to prune outliers
    $PruneMu = 5665;                  # Mean ( 100) of composite distribution
    $PruneSigma = 931;                # Std. dev. ( 100) of composite distribution
    $PruneZ = 1;                      # Standard deviations to prune
    $PruneInverse = 0;                # Keep only outliers if nonzero

    require 'readrad.pl';

    $Longitude = -7;                  # Longitude (- = East, + = West)

    $day = 24 * 60 * 60;

    srand(1234);

    while (($counts, $time) = &readrad) {
        if ($time == -1) {
            last;
        }

        #   Random data subset selection
        if ($Datasel) {
            if ((int(rand(32768)) & 3) != 2) {
                next;
            }
        }

        #   Outlier pruning
        if ($Prune) {
            if ($PruneInverse ^
                (($counts < ($PruneMu - ($PruneSigma * $PruneZ))) ||
                 ($counts > ($PruneMu + ($PruneSigma * $PruneZ))))) {
#               print(STDERR "Prune $counts\n");
                next;
            }
        }

        #   Calculate local solar time from UTC

#($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);
#printf("UTC: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);

        $time -= ($Longitude / 15) * (60 * 60);
#($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);
#printf("LST: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);

        $hour = int(($time % $day) / (60 * 60));
        $histo[$hour] += $counts;
        $points[$hour]++;
#print("$time $hour\n");
    }

    for ($i = 0; $i < 24; $i++) {
        if (!(defined $histo[$i])) {
            $rad = 0;
            $histo[$i] = 0;
        } else {
            $rad = $histo[$i] / ($points[$i] * 354.0);
        }
        print("$i,$histo[$i],$points[$i],$rad\n");
    }
