
    #   Print histogram of minutes with given numbers of counts
    #   after selection.

    require 'readrad.pl';

    $Longitude = -7;                  # Longitude (- = East, + = West)

    $day = 24 * 60 * 60;

    $cmin = 99999999;
    $cmax = 0;

    $Prune = 0;                       # Nonzero to prune outliers
    $PruneMu = 5665;                  # Mean ( 100) of composite distribution
    $PruneSigma = 931;                # Std. dev. ( 100) of composite distribution
    $PruneZ = 2;                      # Standard deviations to prune
    $PruneInverse = 1;                # Keep only outliers if nonzero

    $Timesel = 1;                     # Select by time of day
    $Timestart = 18;                  # Start hour  (inclusive)
    $Timeend = 19;                    # End hour    (inclusive)
#   $Timestart = 8;                   # Start hour  (inclusive)
#   $Timeend = 9;                     # End hour    (inclusive)

    while (($counts, $time) = &readrad) {
        if ($time == -1) {
            last;
        }

        #   Outlier pruning
        if ($Prune) {
            if ($PruneInverse ^
                (($counts < ($PruneMu - ($PruneSigma * $PruneZ))) ||
                 ($counts > ($PruneMu + ($PruneSigma * $PruneZ))))) {
#               print(STDERR "Prune $counts\n");
                next;
            }
        }

        #   Calculate local solar time from UTC

#($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);
#printf("UTC: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);

        $time -= ($Longitude / 15) * (60 * 60);
#($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);
#printf("LST: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);

        $hour = int(($time % $day) / (60 * 60));
        $counts = int($counts / 100);

        if ($Timesel) {
            if (!(($hour >= $Timestar) && ($hour <= $Timeend))) {
                next;
            }
        }

        if ($counts < $cmin) {
            $cmin = $counts;
        }
        if ($counts > $cmax) {
            $cmax = $counts;
        }

        $histo[$counts]++;
    }

    for ($i = 0; $i <= $cmax; $i++) {
        if (!(defined $histo[$i])) {
            $histo[$i] = 0;
        }
        print("$i,$histo[$i]\n");
    }
