
    #   Read background radiation CSV file and bin
    #   into local solar time by minutes.

    require 'readrad.pl';

    $Longitude = -7;                  # Longitude (- = East, + = West)

    $day = 24 * 60 * 60;

    $smooth = 0.1;                    # Smoothing factor
    $smoothed = -1;

    while (($counts, $time) = &readrad) {
        if ($time == -1) {
            last;
        }

        #   Calculate local solar time from UTC

#($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);
#printf("UTC: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);

        $time -= ($Longitude / 15) * (60 * 60);
#($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);
#printf("LST: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);

        $minute = int(($time % $day) / 60);
        $histo[$minute] += $counts;
        $points[$minute]++;
    }

    for ($i = 0; $i < 24 * 60; $i++) {
        if (!(defined $histo[$i])) {
            $rad = 0;
            $histo[$i] = 0;
        } else {
            $rad = $histo[$i] / ($points[$i] * 354.0);
        }
        $j = $i / (24 * 60);
        if ($smoothed < 0) {
            $smoothed = $rad;
        } else {
            $smoothed = $smoothed + $smooth * ($rad - $smoothed);
        }
        print("$j,$histo[$i],$points[$i],$rad,$smoothed\n");
    }
