
    #   Report coverage by month--how many samples did we take
    #   in a given calendar month summing over years.

    #   Output:  CSV file with fields:
    #       1:  Month number (1 - 12)
    #       2:  Counts in this month
    #       3:  Seconds of data taken for month
    #       4:  Average flux per month

    require 'readrad.pl';

    $day = 24 * 60 * 60;
    $lm = -1;

    while (($counts, $time) = &readrad) {
        if ($time == -1) {
            last;
        }

        ($sec, $min, $hour, $mday, $mon, $year) = gmtime($time);

#if ($lm != $mday) {
#printf(STDERR "GMT: %d/%d/%d %2d:%02d\n", $year + 1900, $mon + 1, $mday, $hour, $min);
#$lm = $mday;
#}

        $hour = int(($time % $day) / (60 * 60));
        $histo[$mon] += $counts;
        $points[$mon]++;
    }

    for ($i = 0; $i < 12; $i++) {
        if (!(defined $histo[$i])) {
            $rad = 0;
            $histo[$i] = 0;
        } else {
            $rad = $histo[$i] / ($points[$i] * 354.0);
        }
        $m = $i + 1;
        print("$m,$histo[$i],$points[$i],$rad\n");
    }
