/*

    This table translates the characters with codes between
    128 and 255 from the MS-DOS Code Page 850 character set
    to ISO 8859-1.  Characters in the range 0--127 are almost
    the same in both sets; the only difference is that character
    127 is DEL in ISO (and ASCII), but a delta character in
    Code Page 850.  Since no such character exists in ISO,
    it has to be ditched anyway.
    
*/

static unsigned char cp850_to_ISO[256] = {
    0x00,  //  0x00  ?
    0x00,  //  0x01  ?
    0x00,  //  0x02  ?
    0x00,  //  0x03  ?
    0x00,  //  0x04  ?
    0x00,  //  0x05  ?
    0x00,  //  0x06  ?
    0x00,  //  0x07  ?
    0x00,  //  0x08  ?
    0x00,  //  0x09  ?
    0x00,  //  0x0A  ?
    0x00,  //  0x0B  ?
    0x00,  //  0x0C  ?
    0x00,  //  0x0D  ?
    0x00,  //  0x0E  ?
    0x00,  //  0x0F  ?

    0x00,  //  0x10  ?
    0x00,  //  0x11  ?
    0x00,  //  0x12  ?
    0x00,  //  0x13  ?
    0x00,  //  0x14  ?
    0x00,  //  0x15  ?
    0x00,  //  0x16  ?
    0x00,  //  0x17  ?
    0x00,  //  0x18  ?
    0x00,  //  0x19  ?
    0x00,  //  0x1A  ?
    0x00,  //  0x1B  ?
    0x00,  //  0x1C  ?
    0x00,  //  0x1D  ?
    0x00,  //  0x1E  ?
    0x00,  //  0x1F  ?

    0x20,  //  0x20   
    0x21,  //  0x21  !
    0x22,  //  0x22  "
    0x23,  //  0x23  #
    0x24,  //  0x24  $
    0x25,  //  0x25  %
    0x26,  //  0x26  &
    0x27,  //  0x27  '
    0x28,  //  0x28  (
    0x29,  //  0x29  )
    0x2A,  //  0x2A  *
    0x2B,  //  0x2B  +
    0x2C,  //  0x2C  ,
    0x2D,  //  0x2D  -
    0x2E,  //  0x2E  .
    0x2F,  //  0x2F  /

    0x30,  //  0x30  0
    0x31,  //  0x31  1
    0x32,  //  0x32  2
    0x33,  //  0x33  3
    0x34,  //  0x34  4
    0x35,  //  0x35  5
    0x36,  //  0x36  6
    0x37,  //  0x37  7
    0x38,  //  0x38  8
    0x39,  //  0x39  9
    0x3A,  //  0x3A  :
    0x3B,  //  0x3B  ;
    0x3C,  //  0x3C  <
    0x3D,  //  0x3D  =
    0x3E,  //  0x3E  >
    0x3F,  //  0x3F  ?

    0x40,  //  0x40  @
    0x41,  //  0x41  A
    0x42,  //  0x42  B
    0x43,  //  0x43  C
    0x44,  //  0x44  D
    0x45,  //  0x45  E
    0x46,  //  0x46  F
    0x47,  //  0x47  G
    0x48,  //  0x48  H
    0x49,  //  0x49  I
    0x4A,  //  0x4A  J
    0x4B,  //  0x4B  K
    0x4C,  //  0x4C  L
    0x4D,  //  0x4D  M
    0x4E,  //  0x4E  N
    0x4F,  //  0x4F  O

    0x50,  //  0x50  P
    0x51,  //  0x51  Q
    0x52,  //  0x52  R
    0x53,  //  0x53  S
    0x54,  //  0x54  T
    0x55,  //  0x55  U
    0x56,  //  0x56  V
    0x57,  //  0x57  W
    0x58,  //  0x58  X
    0x59,  //  0x59  Y
    0x5A,  //  0x5A  Z
    0x5B,  //  0x5B  [
    0x5C,  //  0x5C  Backslash
    0x5D,  //  0x5D  ]
    0x5E,  //  0x5E  ^
    0x5F,  //  0x5F  _

    0x60,  //  0x60  `
    0x61,  //  0x61  a
    0x62,  //  0x62  b
    0x63,  //  0x63  c
    0x64,  //  0x64  d
    0x65,  //  0x65  e
    0x66,  //  0x66  f
    0x67,  //  0x67  g
    0x68,  //  0x68  h
    0x69,  //  0x69  i
    0x6A,  //  0x6A  j
    0x6B,  //  0x6B  k
    0x6C,  //  0x6C  l
    0x6D,  //  0x6D  m
    0x6E,  //  0x6E  n
    0x6F,  //  0x6F  o

    0x70,  //  0x70  p
    0x71,  //  0x71  q
    0x72,  //  0x72  r
    0x73,  //  0x73  s
    0x74,  //  0x74  t
    0x75,  //  0x75  u
    0x76,  //  0x76  v
    0x77,  //  0x77  w
    0x78,  //  0x78  x
    0x79,  //  0x79  y
    0x7A,  //  0x7A  z
    0x7B,  //  0x7B  {
    0x7C,  //  0x7C  |
    0x7D,  //  0x7D  }
    0x7E,  //  0x7E  ~
    0x00,  //  0x7F  Del
    
    0xC7,  //  0x80  
    0xFC,  //  0x81  
    0xE9,  //  0x82  
    0xE2,  //  0x83  
    0xE4,  //  0x84  
    0xE0,  //  0x85  
    0xE5,  //  0x86  
    0xE7,  //  0x87  
    0xEA,  //  0x88  
    0xEB,  //  0x89  
    0xE8,  //  0x8A  
    0xEF,  //  0x8B  
    0xEE,  //  0x8C  
    0xEC,  //  0x8D  
    0xC4,  //  0x8E  
    0xC5,  //  0x8F  

    0xC9,  //  0x90  
    0xE6,  //  0x91  
    0xC6,  //  0x92  
    0xF4,  //  0x93  
    0xF6,  //  0x94  
    0xF2,  //  0x95  
    0xFB,  //  0x96  
    0xF9,  //  0x97  
    0xFF,  //  0x98  
    0xD6,  //  0x99  
    0xDC,  //  0x9A  
    0xF8,  //  0x9B  
    0xA3,  //  0x9C  
    0xD8,  //  0x9D  
    0xD7,  //  0x9E  
    0x00,  //  0x9F  Florin

    0xE1,  //  0xA0  
    0xED,  //  0xA1  
    0xF3,  //  0xA2  
    0xFA,  //  0xA3  
    0xF1,  //  0xA4  
    0xD1,  //  0xA5  
    0xAA,  //  0xA6  
    0xBA,  //  0xA7  
    0xBF,  //  0xA8  
    0xAE,  //  0xA9  
    0xAC,  //  0xAA  
    0xBD,  //  0xAB  
    0xBC,  //  0xAC  
    0xA1,  //  0xAD  
    0xAB,  //  0xAE  
    0xBB,  //  0xAF  

    0x00,  //  0xB0  Grey
    0x00,  //  0xB1  Grey
    0x00,  //  0xB2  Grey
    0x00,  //  0xB3  Line
    0x00,  //  0xB4  Line
    0xC1,  //  0xB5  
    0xC2,  //  0xB6  
    0xC0,  //  0xB7  
    0xA9,  //  0xB8  
    0x00,  //  0xB9  Line
    0x00,  //  0xBA  Line
    0x00,  //  0xBB  Line
    0x00,  //  0xBC  Line
    0xA2,  //  0xBD  
    0xA5,  //  0xBE  
    0xC0,  //  0xBF  Line

    0x00,  //  0xC0  Line
    0x00,  //  0xC1  Line
    0x00,  //  0xC2  Line
    0x00,  //  0xC3  Line
    0x00,  //  0xC4  Line
    0x00,  //  0xC5  Line
    0xE3,  //  0xC6  
    0xC3,  //  0xC7  
    0x00,  //  0xC8  Line
    0x00,  //  0xC9  Line
    0x00,  //  0xCA  Line
    0x00,  //  0xCB  Line
    0x00,  //  0xCC  Line
    0x00,  //  0xCD  Line
    0x00,  //  0xCE  Line
    0xA4,  //  0xCF  

    0xF0,  //  0xD0  
    0xD0,  //  0xD1  
    0xCA,  //  0xD2  
    0xCB,  //  0xD3  
    0xC8,  //  0xD4  
    0x00,  //  0xD5  Dotless i
    0xCD,  //  0xD6  
    0xCE,  //  0xD7  
    0xCF,  //  0xD8  
    0x00,  //  0xD9  Line
    0x00,  //  0xDA  Line
    0x00,  //  0xDB  Block
    0x00,  //  0xDC  Block
    0x7C,  //  0xDD  |
    0xCC,  //  0xDE  
    0x00,  //  0xDF  Block

    0xF3,  //  0xE0  
    0xDF,  //  0xE1  
    0xD4,  //  0xE2  
    0xD1,  //  0xE3  
    0xF5,  //  0xE4  
    0xD5,  //  0xE5  
    0xB5,  //  0xE6  
    0xFE,  //  0xE7  
    0xDE,  //  0xE8  
    0xDA,  //  0xE9  
    0xDB,  //  0xEA  
    0xD9,  //  0xEB  
    0xFD,  //  0xEC  
    0xDD,  //  0xED  
    0xAF,  //  0xEE  
    0x27,  //  0xEF  '

    0xAD,  //  0xF0  
    0xB1,  //  0xF1  
    0x3D,  //  0xF2  =
    0xBE,  //  0xF3  
    0xB6,  //  0xF4  
    0xA7,  //  0xF5  
    0x00,  //  0xF6  Raised p
    0x00,  //  0xF7  Hook
    0xB0,  //  0xF8  
    0xA8,  //  0xF9  
    0xB7,  //  0xFA  
    0xB9,  //  0xFB  
    0xB3,  //  0xFC  
    0xB2,  //  0xFD  
    0x00,  //  0xFE  Slug
    0x20   //  0xFF  Blank 'FF'
};
