/*5:*/
#line 191 "etset.w"


#define PRODUCT "etset"
#define VERSION "3.2"
#define REVDATE "2006-05-20" \

#define FormatWidth 70
#define RaggedRightIndent 1
#define PreformattedTableIndent 2
#define QuoteIndent 4
#define TitleMarkerCharacter '='
#define ChapterMarkerCharacter '-'
#define MarkerMinimumLength 3
#define SpecialMarker "<><><>"
#define SpecialPrefix (SpecialMarker"Special:") 
#define PUNCTUATION ("?!:;"RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)  \
 \

#define Iabs(x) (((x) <0) ?(-(x) ) :(x) )  \

#define sectionSep "<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>" \

#define EncodeBodyState(s) ((char) ('A'+(s) ) ) 
#define DecodeBodyState(c) ((bodyState) ((c) -'A') )  \

#define REGISTERED_SIGN "\xAE"
#define C_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK 0xAB
#define C_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK 0xBB
#define RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK "\xBB" \


#line 193 "etset.w"


/*151:*/
#line 2372 "etset.w"

#include "config.h"

#include <iostream> 
#include <iomanip> 
#include <fstream> 
#include <sstream> 
#include <cstdlib> 
#include <exception> 
#include <stdexcept> 
#include <string> 
#include <vector> 
#include <queue> 
#include <map> 
#include <algorithm> 
using namespace std;

#include <stdio.h> 
#include <ctype.h> 
#include <string.h> 
#include <time.h> 
#include <assert.h> 


#ifdef WIN32
#ifdef HAVE_UNISTD_H
#undef HAVE_UNISTD_H
#endif
#ifdef HAVE_STAT
#undef HAVE_STAT
#endif
#define __GNU_LIBRARY__ 1
#define __STDC__ 1
#endif

#ifdef HAVE_STAT
#include <sys/stat.h> 
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h> 
#endif

#include "getopt.h"     

/*:151*/
#line 195 "etset.w"

/*6:*/
#line 202 "etset.w"

/*48:*/
#line 1571 "etset.w"

enum bodyState{
BeginText,
BeforeTitle,
Declarations,
PossibleTitle,
TitleMarker,
DocumentTitle,
Author,
BetweenParagraphs,
InTextParagraph,
InBlockQuote,
InRaggedRight,
InRaggedLeft,
InPreformattedTable,
PossibleChapterNumber,
InCentred,
ChapterNumber,
ChapterMarker,
ChapterName,
EndOfParagraph,
EndOfText
};

/*:48*//*49:*/
#line 1603 "etset.w"

static const char Begin= '{',
Body= ' ',
End= '}',
Void= '-';


/*:49*//*50:*/
#line 1616 "etset.w"

static string const stateNames[]= {
"Begin text",
"B4 Title",
"Declarations",
"Poss Title",
"Title mark",
"Title",
"Author",
"Par break",
"Text",
"Blockquote",
"Rag right",
"Rag left",
"Table",
"Poss Chap",
"Centred",
"Chap num",
"Chap mark",
"Chap name",
"End para",
"End text"
};

/*:50*//*152:*/
#line 2420 "etset.w"


typedef enum{LaTeX,HTML,Palm}outputFormat;

static outputFormat ofmt= LaTeX;
static bool asciiOnly= false;
static bool babelon= false;
static string babelang;
static bool singleFileHTML= false;
static bool debugParser= false;
static bool dosCharacters= false;
static string debugParserFile= "";
static bool flattenISOchars= false;
static bool frenchPunct= false;
static string savePrologueFile= "";
static string saveEpilogueFile= "";
static bool specialStrip= false;
static bool strictCompliance= false;
static bool unicodeChars= false;
static bool cleanText= false;
static bool checkText= false;
static bool verbose= false;

/*:152*//*155:*/
#line 2619 "etset.w"

static string infile= "-",
outfile= "-";

/*:155*//*160:*/
#line 2732 "etset.w"

static const char*const texform[]= {
"!`","\\makebox{\\rm\\rlap/c}","\\pounds","$\\otimes$",
"\\makebox{\\rm\\rlap Y{\\hspace*{0.07em}\\scriptsize =}}","$|$",
"{\\S}","\\\"{}","{\\copyright}","\\b{a}",
"{\\raisebox{0.3ex}{\\tiny$\\ll$~}}",
"$\\neg$","$-$",
"{\\ooalign{\\hfil\\raise.07ex\\hbox{\\sc r}\\hfil\\crcr\\mathhexbox20D}}",
"-","$^{\\circ}$","$\\pm$","$^2$","$^3$","\\'{}","$\\mu$",
"{\\P}","$\\cdot$","\\c{}","$^1$","\\b{o}",
"{\\raisebox{0.3ex}{\\tiny~$\\gg$}}",
"{\\small $1/4$}","{\\small $1/2$}","{\\small $3/4$}","?`",
"\\`{A}","\\'{A}","\\^{A}","\\~{A}","\\\"{A}","{\\AA}",
"{\\AE}","\\c{C}","\\`{E}","\\'{E}","\\^{E}","\\\"{E}",
"\\`{I}","\\'{I}","\\^{I}","\\\"{I}","Eth","\\~{N}",
"\\`{O}","\\'{O}","\\^{O}","\\~{O}","\\\"{O}","$\\times$",
"{\\O}","\\`{U}","\\'{U}","\\^{U}","\\\"{U}","\\'{Y}",
"Thorn","{\\ss}","\\`{a}","\\'{a}","\\^{a}","\\~{a}",
"\\\"{a}","{\\aa}","{\\ae}","\\c{c}","\\`{e}","\\'{e}",
"\\^{e}","\\\"{e}","\\`{\\i}","\\'{\\i}","\\^{\\i}",
"\\\"{\\i}","eth","\\~{n}","\\`{o}","\\'{o}","\\^{o}",
"\\~{o}","\\\"{o}","$\\div$","{\\o}","\\`{u}","\\'{u}",
"\\^{u}","\\\"{u}","\\'{y}","thorn","\\\"{y}"
};

/*:160*//*161:*/
#line 2769 "etset.w"


#include "cp850.h"

/*:161*//*162:*/
#line 2782 "etset.w"


static const char*const flattenISO[]= {
" ",
"!",
"cents",
"GBP",
"$",
"JPY",
"|",
"Sec.",
"''",
"(C)",
"a",
"<<",
"NOT",
"",
"(R)",
"-",
"o",
"+/-",
"^2",
"^3",
"'",
"mu",
"PP.",
".",
",",
"^1",
"o",
">>",
"1/4",
"1/2",
"3/4",
"?",
"A",
"A",
"A",
"A",
"A",
"A",
"Ae",
"C",
"E",
"E",
"E",
"E",
"I",
"I",
"I",
"I",
"Th",
"N",
"O",
"O",
"O",
"O",
"O",
"x",
"O",
"U",
"U",
"U",
"U",
"Y",
"Th",
"ss",
"a",
"a",
"a",
"a",
"a",
"a",
"ae",
"c",
"e",
"e",
"e",
"e",
"i",
"i",
"i",
"i",
"th",
"n",
"o",
"o",
"o",
"o",
"o",
"/",
"o",
"u",
"u",
"u",
"u",
"y",
"th",
"y"
};



#line 1 "log.w"

/*:162*/
#line 203 "etset.w"

/*153:*/
#line 2448 "etset.w"

static void usage(void)
{
cout<<PRODUCT<<"  --  Typeset ISO 8859 Latin-1 Etext.  Call\n";
cout<<"           with "<<PRODUCT<<" [input [output]]\n";
cout<<"\n";
cout<<"Options:\n";
cout<<"    --ascii-only           Permit only 7-bit ASCII characters in input\n";
cout<<"    --babel lang           Use LaTeX babel package for lang\n";
cout<<"    --check                Check text for publication\n";
cout<<"    --clean                Clean: expand tabs, remove trailing white space\n";
cout<<"    --copyright            Print copyright information\n";
cout<<"    --debug-parser file    Write parser debugging log to file\n";
cout<<"    --dos-characters       Translate MS-DOS characters to ISO 8859\n";
cout<<"    --flatten-iso          Flatten ISO 8859-1 8-bit codes to ASCII\n";
cout<<"    --french-punctuation   Use nonbreaking spaces for French punctuation\n";
cout<<"    --help, -u             Print this message\n";
cout<<"    --html, -h             Generate HTML\n";
cout<<"    --latex, -l            Generate LaTeX\n";
cout<<"    --palm, -p             Generate Palm"REGISTERED_SIGN" Reader document\n";
cout<<"    --save-epilogue file   Save epilogue in file\n";
cout<<"    --save-prologue file   Save prologue in file\n";
cout<<"    --single-file          Single file for HTML output\n";
cout<<"    --special-strip        Strip format-specific special commands\n";
cout<<"    --strict               Strict compliance with XHTML 1.0 Strict DTD\n";
cout<<"    --unicode              Use XHTML Unicode text entities for special characters\n";
cout<<"    --verbose, -v          Print processing information\n";
cout<<"    --version              Print version number\n";
cout<<"\n";
cout<<"by John Walker\n";
cout<<"http://www.fourmilab.ch/\n";
}

/*:153*/
#line 204 "etset.w"

/*8:*/
#line 234 "etset.w"




static const string fTypeName[4]= {"Undefined","Source","Filter","Sink"};

class textComponent{
protected:
textComponent*output;
textComponent*source;
int lineNumber;
enum filterType{UndefinedType= 0,SourceType= 1,FilterType= 2,SinkType= 3};
filterType fType;
public:

textComponent(){
output= NULL;
source= NULL;
lineNumber= 0;
fType= UndefinedType;
}

virtual~textComponent(){}

virtual string componentName(void)= 0;

virtual void put(string s)= 0;

/*9:*/
#line 337 "etset.w"


virtual void setOutput(textComponent&ofilt){
output= &ofilt;
ofilt.source= source;
}

textComponent&operator|(textComponent&dest){
setOutput(dest);
return dest;
}
/*:9*/
#line 262 "etset.w"
;

/*10:*/
#line 365 "etset.w"

virtual void emit(string s,textComponent*destination= NULL){
if(destination==NULL){
destination= output;
}
if(destination==NULL){
throw(invalid_argument("void destination in emit()"));
}
lineNumber++;
destination->put(s);
}

/*:10*/
#line 264 "etset.w"
;

/*11:*/
#line 392 "etset.w"

virtual void eof(void){
output->eof();
}


/*:11*/
#line 266 "etset.w"
;

textComponent*getSource(void){
assert(source!=NULL);
return source;
}

int getLineNumber(void){
return lineNumber;
}

int getSourceLineNumber(void){
return getSource()->getLineNumber();
}


virtual void issueMessage(string msg,ostream&of= cerr){
of<<getSourceLineNumber()<<": "<<msg<<"\n";
}


virtual void writeDescription(ostream&of){
of<<fTypeName[fType]<<": "<<componentName()<<"\n";
};
};

/*:8*//*12:*/
#line 406 "etset.w"

class textSource:public textComponent{
protected:
virtual bool get(string&s)= 0;

public:
textSource(){
fType= SourceType;
source= this;
}

void put(string s){
throw(invalid_argument("cannot put to a source"));
}

virtual void send(void){
string s;

while(get(s)){
emit(s);
}
eof();
}
};

/*:12*//*13:*/
#line 438 "etset.w"

class streamSource:public textSource{
private:
istream*i;
bool strip;

protected:
bool get(string&s){
return getline(*i,s);
}

public:
string componentName(void){
return"streamSource";
}

void openFile(string pathName)

{
if(pathName=="-"){
i= &cin;
}else{
i= new ifstream(pathName.c_str(),ios::in);
if(!(*i)){
throw(invalid_argument("Cannot open input file \""+pathName+"\"."));
}
}
}

streamSource(istream&is= cin)

{
i= &is;
strip= false;
}

streamSource(string pathName)

{
openFile(pathName);
strip= false;
}

void setStripEOL(bool dostrip){
strip= dostrip;
}

bool getStripEOL(void){
return strip;
}

virtual void emit(string s,textComponent*destination= NULL){
if(strip){
if(s[s.length()-1]=='\r'){
s.erase(s.length()-1,1);
}
}
textSource::emit(s,destination);
}
};

/*:13*//*14:*/
#line 504 "etset.w"

class textSink:public textComponent{

public:
textSink(){
fType= SinkType;
}

void setOutput(textComponent&ofilt){
throw(invalid_argument("cannot setOutput of a sink"));
}

virtual void put(string s)


{
lineNumber++;
}

virtual void eof(void)



{
}
};

/*:14*//*15:*/
#line 538 "etset.w"

class streamSink:public textSink{
private:
ostream*o;
bool closeStream;

public:
string componentName(void){
return"streamSink";
}

streamSink(ostream&os):closeStream(false)

{
o= &os;
}

streamSink(string pathName):closeStream(false)

{
if(pathName=="-"){
o= &cout;
}else{
o= new ofstream(pathName.c_str(),ios::out);
closeStream= true;
}
}

~streamSink(){
if(closeStream){
delete o;
}
}

void put(string s){
if(&s!=NULL){
*o<<s<<"\n";
textSink::put(s);
}
}
};

/*:15*//*16:*/
#line 596 "etset.w"

class heatSink:public textSink{
public:
string componentName(void){
return"heatSink";
}

void put(string s){
}
};

/*:16*//*17:*/
#line 613 "etset.w"

class textFilter:public textComponent{

public:
textFilter(){
fType= FilterType;
}
};

/*:17*//*18:*/
#line 627 "etset.w"

class trimFilter:public textFilter{
public:
string componentName(void){
return"trimFilter";
}

void put(string s){
while(s.length()> 0&&isspace(*(s.end()-1))){
s.erase(s.end()-1);
}
emit(s);
}
};

/*:18*//*19:*/
#line 648 "etset.w"

class tabExpanderFilter:public textFilter{
private:
int tabInterval;

public:
string componentName(void){
return"tabExpanderFilter";
}

tabExpanderFilter(int interval= 8){
setTabInterval(interval);
}

void setTabInterval(int interval){
tabInterval= interval;
}

void put(string s){
if(s.find('\t')!=string::npos){
/*20:*/
#line 680 "etset.w"

string os;

string::iterator p;
int n= 0;

for(p= s.begin();p!=s.end();p++){
if(*p=='\t'){
do{
os+= ' ';
n++;
}while((n%tabInterval)!=0);
}else{
os+= *p;
n++;
}
}
s= os;

/*:20*/
#line 668 "etset.w"
;
}
assert(s.find('\t')==string::npos);
emit(s);
}
};

/*:19*//*21:*/
#line 706 "etset.w"

class flattenISOCharactersFilter:public textFilter{

public:
string componentName(void){
return"flattenISOCharactersFilter";
}

void put(string s){
/*22:*/
#line 726 "etset.w"

string os;
string::iterator p;
int c;

for(p= s.begin();p!=s.end();p++){
c= (*p)&0xFF;
if((c>=0xA0)&&(c<=0xFF)){
os+= flattenISO[c-0xA0];
}else{
os+= c;
}
}
s= os;

/*:22*/
#line 715 "etset.w"
;
emit(s);
}
};

/*:21*//*23:*/
#line 748 "etset.w"

class convertForeignCharacterSetToISOFilter:public textFilter{

private:
unsigned char*conversionTable;

public:

void setConversionTable(unsigned char*tbl){
conversionTable= tbl;
}

convertForeignCharacterSetToISOFilter(unsigned char*tbl){
setConversionTable(tbl);
}

string componentName(void){
return"convertForeignCharacterSetToISOFilter";
}

void identityTransform(void){
int i;

conversionTable= new unsigned char[256];
for(i= 0;i<256;i++){
conversionTable[i]= i;
}
}

unsigned char convert(unsigned char from){
return conversionTable[from];
}

void setTranslation(unsigned char from,unsigned char to){
conversionTable[from]= to;
}

void put(string s){
string::iterator p;

for(p= s.begin();p!=s.end();p++){
*p= convert((*p)&0xFF);
}
emit(s);
}
};

/*:23*//*24:*/
#line 820 "etset.w"

class sectionSeparatorSquid:public textFilter{
private:
textComponent*prologueProcessor,
*epilogueProcessor,
*currentOutput;
int nsep;

public:
sectionSeparatorSquid(textComponent*proP= NULL,textComponent*epiP= NULL){
prologueProcessor= proP;
epilogueProcessor= epiP;
nsep= 0;
currentOutput= prologueProcessor;
}

string componentName(void){
return"sectionSeparatorSquid";
}

void setPrologueProcessor(textComponent*proP){
assert(prologueProcessor==NULL&&currentOutput==NULL);
currentOutput= prologueProcessor= proP;
}

void setEpilogueProcessor(textComponent*epiP){
assert(epilogueProcessor==NULL);
epilogueProcessor= epiP;
}

/*26:*/
#line 917 "etset.w"

void eof(void){
if(currentOutput!=NULL){

currentOutput->eof();
}

switch(nsep){
case 0:




if((currentOutput!=output)&&(output!=NULL)){
output->eof();
if(epilogueProcessor==currentOutput){
epilogueProcessor= NULL;
}
}
currentOutput= output;


case 1:




if((currentOutput!=epilogueProcessor)&&
(epilogueProcessor!=NULL)){
epilogueProcessor->eof();
}

case 2:


break;
}
}

/*:26*/
#line 850 "etset.w"
;

void put(string s){
if(s.compare(sectionSep)==0){
/*25:*/
#line 880 "etset.w"

switch(nsep){
case 0:
nsep++;
if((currentOutput!=NULL)&&(currentOutput!=output)&&
(currentOutput!=epilogueProcessor)){
currentOutput->eof();
}
currentOutput= output;
return;

case 1:
nsep++;
if((currentOutput!=NULL)&&(currentOutput!=epilogueProcessor)){
currentOutput->eof();
}
currentOutput= epilogueProcessor;
return;

case 2:

break;
}

/*:25*/
#line 854 "etset.w"
;
}
if(currentOutput!=NULL){
emit(s,currentOutput);
}
}
};

/*:24*//*27:*/
#line 962 "etset.w"

class teeSquid:public textFilter{
private:
textComponent*secondDestination;

public:
teeSquid(textComponent*secP){
secondDestination= secP;
}

string componentName(void){
return"teeSquid";
}

void eof(void){
secondDestination->eof();
textFilter::eof();
}

void put(string s){
emit(s,secondDestination);
emit(s);
}
};

/*:27*//*28:*/
#line 996 "etset.w"

class etextBodyParserFilter:public textFilter{

private:
bodyState state;
queue<string> lq;
string specialFilter;

void emits(bodyState s,char bracket,string text= ""){
string bracks= "";

bracks+= bracket;
emit(EncodeBodyState(s)+bracks+text);
}

void emitQueuedLines(bodyState s);

public:
etextBodyParserFilter(){
state= BeginText;
specialFilter= "";
}

virtual~etextBodyParserFilter(){
}

string componentName(void){
return"etextBodyParserFilter";
}

void setSpecialFilter(string f){
specialFilter= f;
}

string getSpecialFilter(void){
return specialFilter;
}

void eof(void){
emits(EndOfText,Void);
textFilter::eof();
}

void put(string s){
bodyState lineClass= classifyLine(s);

if(specialFilter!="*"){
if(isLineSpecial(s)){
if(specialType(s)!=specialFilter){
return;
}
}
}
/*29:*/
#line 1072 "etset.w"

while(true){
switch(state){
/*30:*/
#line 1102 "etset.w"

case BeginText:
emits(BeginText,Void);
state= BeforeTitle;
continue;

/*:30*/
#line 1075 "etset.w"
;
/*31:*/
#line 1114 "etset.w"

case BeforeTitle:
if(lineClass!=BetweenParagraphs){
if(isLineSpecial(s)){
emits(Declarations,Begin);
state= Declarations;
continue;
}

if(lineClass==InCentred){
state= PossibleTitle;
lq.push(s);
break;
}

if(lineClass==TitleMarker){
state= TitleMarker;
emits(DocumentTitle,Void);
break;
}




emits(DocumentTitle,Void);
emits(Author,Void);

state= BetweenParagraphs;
continue;
}
break;

/*:31*/
#line 1076 "etset.w"
;
/*32:*/
#line 1156 "etset.w"

case Declarations:
if(isLineSpecial(s)){
emits(Declarations,Body,s);
break;
}
emits(Declarations,End);
state= BeforeTitle;
continue;

/*:32*/
#line 1077 "etset.w"
;
/*33:*/
#line 1173 "etset.w"

case PossibleTitle:
if(lineClass==TitleMarker){
emitQueuedLines(DocumentTitle);
state= TitleMarker;
break;
}

if(lineClass==InCentred){
lq.push(s);
break;
}

if(lineClass==ChapterMarker){






emits(DocumentTitle,Void);
emits(Author,Void);

emitQueuedLines(ChapterNumber);
state= ChapterMarker;
break;
}






emits(DocumentTitle,Void);
emits(Author,Void);
emitQueuedLines(InCentred);
state= BetweenParagraphs;
continue;

/*:33*/
#line 1078 "etset.w"
;
/*34:*/
#line 1218 "etset.w"

case TitleMarker:
if(lineClass==InCentred){
emits(Author,Begin);
emits(Author,Body,s);
state= Author;
break;
}

if(lineClass==BetweenParagraphs){
break;
}



emits(Author,Void);
state= BetweenParagraphs;
continue;

/*:34*/
#line 1079 "etset.w"
;
/*35:*/
#line 1242 "etset.w"

case Author:
if(lineClass==InCentred){
emits(Author,Body,s);
break;
}
emits(Author,End);
state= BetweenParagraphs;
continue;

/*:35*/
#line 1080 "etset.w"
;

/*36:*/
#line 1264 "etset.w"

case BetweenParagraphs:
switch(lineClass){
case BetweenParagraphs:
break;

case InTextParagraph:
case InRaggedRight:
case InBlockQuote:
case InRaggedLeft:
case InPreformattedTable:
emits(lineClass,Begin);
emits(lineClass,Body,s);
state= lineClass;
break;

case InCentred:
case TitleMarker:
lq.push(s);
state= PossibleChapterNumber;
break;

case ChapterMarker:
emits(ChapterNumber,Void);
state= ChapterMarker;
break;

default:
break;
}
break;

/*:36*/
#line 1082 "etset.w"
;
/*37:*/
#line 1308 "etset.w"

case InTextParagraph:
case InRaggedRight:
case InBlockQuote:
case InRaggedLeft:
if(lineClass==state){
emits(state,Body,s);
break;
}

emits(state,End);
state= BetweenParagraphs;
continue;

/*:37*/
#line 1083 "etset.w"
;
/*38:*/
#line 1329 "etset.w"

case InPreformattedTable:
if(lineClass!=BetweenParagraphs){
emits(state,Body,s);
break;
}

emits(state,End);
state= BetweenParagraphs;
break;

/*:38*/
#line 1084 "etset.w"
;
/*39:*/
#line 1353 "etset.w"

case PossibleChapterNumber:
if(lineClass==InCentred){
lq.push(s);
break;
}

if(lineClass==ChapterMarker){
emitQueuedLines(ChapterNumber);
state= ChapterMarker;
break;
}

emitQueuedLines(InCentred);
state= BetweenParagraphs;
continue;

/*:39*/
#line 1085 "etset.w"
;
/*40:*/
#line 1377 "etset.w"

case ChapterMarker:
if(lineClass==InCentred){
emits(ChapterName,Begin);
emits(ChapterName,Body,s);
state= ChapterName;
break;
}

emits(ChapterName,Void);
state= BetweenParagraphs;
continue;

/*:40*/
#line 1086 "etset.w"
;
/*41:*/
#line 1396 "etset.w"

case ChapterName:
if(lineClass==InCentred){
emits(ChapterName,Body,s);
break;
}

emits(ChapterName,End);
state= BetweenParagraphs;
continue;

/*:41*/
#line 1087 "etset.w"
;

default:
cerr<<"Internal error: state \""<<stateNames[state]<<
"\" not handled in etextBodyParserFilter.\n";
exit(1);
}
break;
}

/*:29*/
#line 1049 "etset.w"
;
}

static bodyState classifyLine(string s);

static bool isLineSpecial(string s);

static string specialType(string s);

static string specialCommand(string s);
};

/*:28*//*42:*/
#line 1415 "etset.w"

bodyState etextBodyParserFilter::classifyLine(string s){
bodyState classification;

if(s.length()==0){
classification= BetweenParagraphs;
}else if(s[0]!=' '){
classification= InTextParagraph;
}else{
int i= s.find_first_not_of(' ');

if(i==RaggedRightIndent){
classification= InRaggedRight;
}else if((i==PreformattedTableIndent)&&
(s.find_first_of("   ")!=string::npos)){
classification= InPreformattedTable;
}else if(i==QuoteIndent){
classification= InBlockQuote;
}else if(s.length()==FormatWidth){
classification= InRaggedLeft;
}else{
/*43:*/
#line 1460 "etset.w"

classification= InCentred;
char lchar= s[s.length()-1];

if((lchar==ChapterMarkerCharacter)||(lchar==TitleMarkerCharacter)){
int fchar= s.find_first_not_of(' ');
if(((s.length()-fchar)>=MarkerMinimumLength)&&
(s.find_first_not_of(lchar,fchar)==string::npos)){
classification= (lchar==TitleMarkerCharacter)?TitleMarker:ChapterMarker;
}
}

/*:43*/
#line 1436 "etset.w"
;
}
}

return classification;
}

/*:42*//*44:*/
#line 1485 "etset.w"

bool etextBodyParserFilter::isLineSpecial(string s)
{
unsigned int first= s.find_first_not_of(' ');

if((first!=string::npos)&&
(s.find(SpecialPrefix)==first)&&
(s.rfind(SpecialMarker)==(s.length()-((sizeof SpecialMarker)-1)))){
return true;
}
return false;
}

/*:44*//*45:*/
#line 1507 "etset.w"

string etextBodyParserFilter::specialType(string s)
{
string o= " - invalid -";
unsigned int first= s.find(SpecialPrefix),last;

if(first!=string::npos){
first+= (sizeof SpecialPrefix)-1;
last= s.find(' ',first);
o= s.substr(first,last-first);
}
return o;
}

/*:45*//*46:*/
#line 1528 "etset.w"

string etextBodyParserFilter::specialCommand(string s)
{
string o= "";
unsigned int first= s.find(SpecialPrefix),last;

if(first!=string::npos){
first+= (sizeof SpecialPrefix);
first= s.find(' ',first);
if(first!=string::npos){
last= s.rfind(SpecialMarker);
if(last!=string::npos){
o= s.substr(first+1,(last-first)-1);
}
}
}
return o;
}

/*:46*//*47:*/
#line 1552 "etset.w"

void etextBodyParserFilter::emitQueuedLines(bodyState s){
emits(s,Begin);
while(!lq.empty()){
emits(s,Body,lq.front());
lq.pop();
}
emits(s,End);
}

/*:47*//*51:*/
#line 1651 "etset.w"

class stripSpecialCommandsFilter:public textFilter{
private:
bool lastBlank,lastStripped;

public:
stripSpecialCommandsFilter(){
lastBlank= lastStripped= false;
}

string componentName(void){
return"stripSpecialCommandsFilter";
}

void put(string s){
if(etextBodyParserFilter::isLineSpecial(s)){
lastStripped= true;
}else{
if(s.length()> 0){
emit(s);
lastStripped= lastBlank= false;
}else{
if(lastStripped){
if(!lastBlank){
emit(s);
}
lastStripped= false;
lastBlank= true;
}else{
emit(s);
lastBlank= true;
}
}
}
}
};

/*:51*//*52:*/
#line 1699 "etset.w"

class auditFilter:public textFilter{
public:
enum audit_criteria{
trailing_blanks= 1,
embedded_tabs= 2,
exceeds_maximum_length= 4,
invalid_characters= 8,
dubious_justification= 16,
improper_embedded_blanks= 32,
consecutive_blank_lines= 64,
special_commands_present= 128,
permit_8_bit_ISO_characters= 256,
trailing_hyphen= 512,

everything= ~0
};

private:
static const int DefaultCentringTolerance= 2;

unsigned int maxLineLength;
ostream*log;
bool lastBlank;
bool inTable;
enum audit_criteria check;
int centringTolerance;

public:
string componentName(void){
return"auditFilter";
}

void setMaxLength(unsigned int maxlen){
maxLineLength= maxlen;
}

void setLogStream(ostream&s){
log= &s;
}

void setAuditCriteria(int check_for){
check= (audit_criteria)check_for;
}

audit_criteria getAuditCriteria(void){
return check;
}

void enableAuditCriteria(int check_for){
check= (audit_criteria)(check|check_for);
}

void disableAuditCriteria(int check_for){
check= (audit_criteria)(check&(~check_for));
}

void setCentringTolerance(int ct= DefaultCentringTolerance){
centringTolerance= ct;
}

int getCentringTolerance(void){
return centringTolerance;
}

auditFilter(unsigned int maxlen= FormatWidth,ostream&os= cerr,
audit_criteria check_for= everything){
setMaxLength(maxlen);
setLogStream(os);
lastBlank= false;
inTable= false;
setAuditCriteria(check_for);
setCentringTolerance();
}

static bool isCharacterPermissible(unsigned int c);

static string quoteArbitraryString(string s);

static bool isISOletter(int c){
assert((c>=0)&&(c<=0xFF));
return((c>='A')&&(c<='Z'))||
((c>='a')&&(c<='z'))||
((c>=0xC0)&&(c<=0xD6))||
((c>=0xD8)&&(c<=0xF6))||
(c>=0xF8);
}

void put(string s){
unsigned int i,n;
bool err= false;
const string sentenceEnd= ".?!\"\'";
bodyState lclass;
bool special= etextBodyParserFilter::isLineSpecial(s);

/*53:*/
#line 1816 "etset.w"

if(check&trailing_blanks){
int j;

n= 0;
for(j= s.length()-1;j>=0;j--){
if(!isspace(s[j])){
break;
}
n++;
}
if(n> 0){
ostringstream em;

em<<"Line contains "<<n<<" white space character"<<
(n==1?"":"s")<<" at the end.";
issueMessage(em.str(),*log);
err= true;
}
}

/*:53*/
#line 1794 "etset.w"
;
/*54:*/
#line 1845 "etset.w"

if(check&trailing_hyphen){
if((s.length()>=2)&&(s[s.length()-1]=='-')){
int p= s[s.length()-2]&0xFF;

if(isISOletter(p)){
ostringstream em;

em<<"Line contains an apparent hyphen at the end.";
issueMessage(em.str(),*log);
err= true;
}
}
}

/*:54*/
#line 1795 "etset.w"
;
/*55:*/
#line 1873 "etset.w"

if(check&embedded_tabs){
if((i= s.find('\t'))!=string::npos){
for(;i<s.length();i++){
if(s[i]=='\t'){
ostringstream em;

em<<"Line contains tab character in column "<<(i+1)<<".";
issueMessage(em.str(),*log);
err= true;
}
}
}
}

/*:55*/
#line 1796 "etset.w"
;
/*57:*/
#line 1933 "etset.w"

if((check&exceeds_maximum_length)&&(!special)&&
(s.length()> maxLineLength)){
ostringstream em;

em<<"Line (length "<<s.length()<<") exceeds maximum of "<<
maxLineLength<<" characters.";
issueMessage(em.str(),*log);
err= true;
}


/*:57*/
#line 1797 "etset.w"
;
/*58:*/
#line 1954 "etset.w"

if(check&invalid_characters){
for(i= 0;i<s.length();i++){
if((!isCharacterPermissible(s[i]))||
(((!(check&permit_8_bit_ISO_characters))&&
((s[i]&0xFF)>=127)))){
if((s[i]!='\t')||(!(check&embedded_tabs))){
ostringstream em;

em<<"Invalid character 0x"<<hex<<(s[i]&0xFF)<<
dec<<" in column "<<(i+1)<<".";
issueMessage(em.str(),*log);
err= true;
}
}
}
}

/*:58*/
#line 1798 "etset.w"
;
/*59:*/
#line 1984 "etset.w"

if((check&dubious_justification)&&!special){
lclass= etextBodyParserFilter::classifyLine(s);
if(lclass==InPreformattedTable){
inTable= true;
}else if(lclass==BetweenParagraphs){
inTable= false;
}else if(!inTable&&(lclass==InCentred)){
int l,r;

l= s.find_first_not_of(' ');
r= maxLineLength-s.length();
if(Iabs(l-r)> centringTolerance){
ostringstream em;

em<<"Dubious centred line.  "<<l<<" spaces at left, "<<
r<<" spaces at right.";
issueMessage(em.str(),*log);
err= true;
}
}
}

/*:59*/
#line 1799 "etset.w"
;
/*56:*/
#line 1895 "etset.w"

if((check&improper_embedded_blanks)&&(!inTable)&&(!special)){
i= s.find_first_not_of(' ');
if(i!=string::npos){
while((i= s.find("  ",i))!=string::npos){
if((i> 0)&&(sentenceEnd.find(s[i-1])!=string::npos)){
if(s.substr(i+2,1)==" "){
ostringstream em;

em<<"Line contains extra embedded space after sentence end in column "<<
(i+1)<<".";
issueMessage(em.str(),*log);
err= true;
i+= 3;
}else{
i+= 2;
}
}else{
ostringstream em;

em<<"Line contains extra embedded space in column "<<(i+1)<<".";
issueMessage(em.str(),*log);
err= true;
i+= 2;
}
}
}
}

/*:56*/
#line 1800 "etset.w"
;
/*60:*/
#line 2013 "etset.w"

if(check&consecutive_blank_lines){
if(s.find_first_not_of(' ')==string::npos){
if(lastBlank){
issueMessage("This and previous line are both blank.",*log);
err= true;
}
lastBlank= true;
}else{
lastBlank= false;
}
}

/*:60*/
#line 1801 "etset.w"
;
/*61:*/
#line 2035 "etset.w"

if((check&special_commands_present)&&special){
issueMessage("Special command present in text.",*log);
err= true;
}

/*:61*/
#line 1802 "etset.w"
;
if(err){
issueMessage(quoteArbitraryString(s),*log);
}
emit(s);
}
};

/*:52*//*62:*/
#line 2061 "etset.w"

bool auditFilter::isCharacterPermissible(unsigned int c)
{
if(c<' '){
return false;
}
if(c>=127&&c<161){
return false;
}
return true;
}

/*:62*//*63:*/
#line 2081 "etset.w"

string auditFilter::quoteArbitraryString(string s)
{
string o= "";
string::iterator cp;
unsigned int c;

for(cp= s.begin();cp<s.end();cp++){
c= (*cp)&0xFF;
if(isCharacterPermissible(c)){
if((c==' ')&&
(s.find_first_not_of(' ',(cp+1)-s.begin())==string::npos)){
o+= "\\x20";
}else{
o+= c;
}
}else{
ostringstream eh;

eh<<"\\x"<<hex<<setw(2)<<setfill('0')<<c;
o+= eh.str();
}
}

return o;
}

/*:63*//*64:*/
#line 2117 "etset.w"

class parserDiagnosticFilter:public textFilter{
private:

public:

string componentName(void){
return"parserDiagnosticFilter";
}

void put(string s){
bodyState rtype= DecodeBodyState(s[0]);
string spaces= "            ",
stateName= "";

stateName+= stateNames[rtype];
emit(s.substr(1,1)+" "+stateName+spaces.substr(0,12-stateName.length())+
s.substr(2));
}
};

/*:64*//*66:*/
#line 2148 "etset.w"

class textSubstituter{
private:
deque<string> fromString;
deque<string> toString;

public:
void addSubstitution(string from,string to){
fromString.push_back(from);
toString.push_back(to);
}

string substitute(string s);
};

/*:66*//*67:*/
#line 2169 "etset.w"

string textSubstituter::substitute(string s){
deque<string> ::iterator f= fromString.begin();
deque<string> ::iterator t= toString.begin();
string o= s;

while(f!=fromString.end()){
unsigned int i= 0,n;

while((n= o.find(*f,i))!=string::npos){
o.replace(n,f->length(),*t);
i= n+t->length();
}

f++;
t++;
}

return o;
}





#line 1 "latex.w"
/*:67*//*68:*/
#line 6 "latex.w"

class LaTeXGenerationFilter:public textFilter{
private:
bool italics,inmath,quoth,hastitle,hasauthor,
intable,firstchap;
int footnest;
textSubstituter transformer;

string quoteLaTeXString(string s);

void emitq(string s){
emit(quoteLaTeXString(s));
}

void generateAlignedParagraph(string envtype,char bracket,string text,
string terminator= "\\\\");

bool isSubstitution(string s);

public:
LaTeXGenerationFilter(){
italics= inmath= quoth= false;
hastitle= hasauthor= false;
intable= firstchap= false;
footnest= 0;
}

virtual~LaTeXGenerationFilter(){
}

string componentName(void){
return"LaTeXGenerationFilter";
}

void put(string s);
};

/*:68*//*69:*/
#line 51 "latex.w"

void LaTeXGenerationFilter::put(string s){
bodyState state= DecodeBodyState(s[0]);
char bracket= s[1];
string text= s.substr(2);

switch(state){
case BeginText:
/*70:*/
#line 124 "latex.w"

emit("\\documentclass{book}");
{
time_t t= time(NULL);
string stime= ctime(&t);
stime= stime.substr(0,stime.length()-1);

emit("% Translated by "PRODUCT" "VERSION" ("REVDATE") on "+stime);
}
if(babelon){
emit("\\usepackage["+babelang+"]{babel}");
emit("\\usepackage[latin1]{inputenc}");
emit("\\usepackage[T1]{fontenc}");
}else{
if(frenchPunct){
emit("\\frenchspacing");
}
}
break;

/*:70*/
#line 59 "latex.w"
;

case Declarations:
/*71:*/
#line 150 "latex.w"

if(bracket==Body){
assert(etextBodyParserFilter::isLineSpecial(text));
if(!isSubstitution(text)){
emit(etextBodyParserFilter::specialCommand(text));
}
}
break;

/*:71*/
#line 62 "latex.w"
;

case DocumentTitle:
/*72:*/
#line 164 "latex.w"

switch(bracket){
case Begin:
emit("\\title{");
break;

case Body:
emitq(text);
break;

case End:
emit("}");
hastitle= true;
break;

case Void:
hastitle= false;
break;
}
break;

/*:72*/
#line 65 "latex.w"
;

case Author:
/*73:*/
#line 196 "latex.w"

switch(bracket){
case Begin:
emit("\\author{");
break;

case Body:
emitq(text);
break;

case End:
emit("}");
hasauthor= true;


case Void:
if(hastitle||hasauthor){
if(!hastitle){
emit("\\title{}");
}
if(!hasauthor){
emit("\\author{}");
}
}
emit("\\begin{document}");
if(hastitle||hasauthor){
emit("\\maketitle");
}
break;
}
break;

/*:73*/
#line 68 "latex.w"
;

case ChapterNumber:
break;

case ChapterName:
/*74:*/
#line 233 "latex.w"

switch(bracket){
case Begin:
if(!firstchap){
firstchap= true;
emit("\\tableofcontents");
}
emit("\\chapter{");
break;

case Body:
emitq(text);
break;

case End:
emit("}");
break;

case Void:
emit("\\chapter{}");
break;
}
break;

/*:74*/
#line 74 "latex.w"
;

case InTextParagraph:
/*75:*/
#line 264 "latex.w"

switch(bracket){
case Begin:
emit("");
quoth= false;
break;

case Body:
if(etextBodyParserFilter::isLineSpecial(text)){
if(!isSubstitution(text)){
emit(etextBodyParserFilter::specialCommand(text));
}
}else{
emitq(text);
}
break;

case End:
case Void:
break;
}
break;


/*:75*/
#line 77 "latex.w"
;

case InBlockQuote:
generateAlignedParagraph("quote",bracket,text,"");
break;

case InRaggedRight:
generateAlignedParagraph("flushleft",bracket,text);
break;

case InRaggedLeft:
generateAlignedParagraph("flushright",bracket,text);
break;

case InPreformattedTable:
if(bracket==Begin){
intable= true;
}
generateAlignedParagraph("verbatim",bracket,text,"");
if(bracket==End){
intable= false;
}
break;

case InCentred:
generateAlignedParagraph("center",bracket,text);
break;

case EndOfText:
emit("\\end{document}");
if(verbose){
cerr<<"LaTeX: "<<getLineNumber()<<" lines output.\n";
}
break;

default:
cerr<<"*** State "<<stateNames[state]<<" "<<bracket<<
" not handled in LaTeXGenerationFilter ***\n";
exit(1);
}
}

/*:69*//*76:*/
#line 293 "latex.w"

void LaTeXGenerationFilter::generateAlignedParagraph(string envtype,char bracket,string text,
string terminator){
switch(bracket){
case Begin:
emit("");
emit("\\begin{"+envtype+"}");
quoth= false;
break;

case Body:
if(etextBodyParserFilter::isLineSpecial(text)){
if(!isSubstitution(text)){
emit(etextBodyParserFilter::specialCommand(text));
}
}else{
emit(quoteLaTeXString(text)+terminator);
}
break;

case End:
emit("\\end{"+envtype+"}");
break;

case Void:
break;
}
}

/*:76*//*77:*/
#line 328 "latex.w"

string LaTeXGenerationFilter::quoteLaTeXString(string s)
{
string::iterator cp;
string o= "";
int c;
static const string mathModeQuoted= "|<>",
punctuation= "?!:;",
quotedCharacters= "$&%#",
quotedTextCharacters= "{}";

for(cp= s.begin();cp<s.end();cp++){
c= (*cp)&0xFF;

if(c<' '){
/*78:*/
#line 387 "latex.w"

if(isspace(c)){
o+= c;
}else{
o+= "\\verb+^";
o+= ('@'+c);
o+= '+';
}

/*:78*/
#line 343 "latex.w"
;

}else if(c> 160){
/*79:*/
#line 402 "latex.w"

if(babelon){
o+= c;
}else{
o+= texform[c-161];
}

/*:79*/
#line 346 "latex.w"
;

}else if(c>=' '&&c<='~'){
if(!inmath&&!intable&&c=='_'){
/*80:*/
#line 413 "latex.w"

italics= !italics;
if(italics){
o+= "{\\it ";
}else{
o+= "}";
}

/*:80*/
#line 350 "latex.w"
;
}else if(!intable&&c=='\\'&&
((cp+1)<s.end())&&((cp[1]=='(')||(cp[1]==')'))){
/*81:*/
#line 428 "latex.w"

o+= c;
inmath= cp[1]=='(';

/*:81*/
#line 353 "latex.w"
;
}else if(!inmath&&!intable&&((cp+2)<s.end())&&
((c=='[')||((c==' ')&&(cp[1]=='['))||
((c==' ')&&(cp[1]==' ')&&(cp[2]=='[')))){
/*82:*/
#line 437 "latex.w"

footnest++;
o+= "\\footnote{";
if((c==' ')&&((cp+1)<s.end())){
if(cp[1]==' '){
cp++;
}
cp++;
}

/*:82*/
#line 357 "latex.w"
;
}else if(!inmath&&!intable&&c==']'){
/*83:*/
#line 450 "latex.w"

o+= '}';
if(footnest==0){
issueMessage("Mismatched end of footnote (\"]\") bracket.");
}else{
footnest--;
}

/*:83*/
#line 359 "latex.w"
;
}else if(!inmath&&!intable&&(c=='-')&&((cp+1)<s.end())&&(cp[1]=='-')){
/*84:*/
#line 463 "latex.w"

o+= "---";
cp++;

/*:84*/
#line 361 "latex.w"
;
}else if(!inmath&&!intable&&(c=='.')&&((cp+2)<s.end())&&
(cp[1]=='.')&&(cp[2]=='.')){
/*85:*/
#line 471 "latex.w"

o+= "\\ldots";
if(cp[2]==' '){
o+= " ";
}else{
o+= "\\ ";
}
cp+= 2;

/*:85*/
#line 364 "latex.w"
;
}else if(!intable&&((c=='~')||((!inmath)&&(c=='^')))){
/*86:*/
#line 485 "latex.w"

o+= "\\verb+";
o+= c;
o+= '+';

/*:86*/
#line 366 "latex.w"
;
}else if((!inmath&&!intable)&&(mathModeQuoted.find_first_of(c)!=string::npos)){
/*87:*/
#line 494 "latex.w"

o+= '$';
o+= c;
o+= '$';

/*:87*/
#line 368 "latex.w"
;
}else if(!inmath&&!intable&&c=='"'){
/*88:*/
#line 505 "latex.w"

o+= quoth?"''":"``";
quoth= !quoth;

/*:88*/
#line 370 "latex.w"
;
}else{
/*89:*/
#line 513 "latex.w"

if(!inmath&&frenchPunct&&(punctuation.find_first_of(c)!=string::npos)&&
(((cp+1)==s.end())||isspace(cp[1])||
((cp[1]&0xFF)==C_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)||(cp[1]==','))){
o+= "{\\small~}";
o+= c;
}else{




if(quotedCharacters.find_first_of(c)!=string::npos){
o+= '\\';
}
if(!inmath&&(quotedTextCharacters.find_first_of(c)!=string::npos)){
o+= '\\';
}
o+= c;
}

/*:89*/
#line 372 "latex.w"
;
}
}


}
o= transformer.substitute(o);
return o;
}

/*:77*//*90:*/
#line 537 "latex.w"

bool LaTeXGenerationFilter::isSubstitution(string cmd)
{
string s= etextBodyParserFilter::specialCommand(cmd);
bool isSub= false,bogus= true;
unsigned int n,m,l;
char delim;

if(s.find("Substitute ")==0){
isSub= true;
s= s.substr(11);
n= s.find_first_not_of(' ');
if(n!=string::npos){
delim= s[n];
m= s.find(delim,n+1);
if(m!=string::npos){
l= s.find(delim,m+1);
if(l!=string::npos){
bogus= false;
transformer.addSubstitution(s.substr(n+1,(m-n)-1),
s.substr(m+1,(l-m)-1));
}
}
}
if(bogus){
issueMessage("Invalid LaTeX Substitute special",cerr);
issueMessage(auditFilter::quoteArbitraryString(cmd),cerr);
}
}
return isSub;
}
#line 1 "html.w"
/*:90*//*91:*/
#line 22 "html.w"

class HTMLGenerationSink:public textSink{
private:
static const int defaultFootnotePad= 60;

bool italics,inmath,infoot,firstchap,quoth,hastitle,hasauthor;
string basename;
string stime;
string indexFileName;
ofstream*index;
ofstream*chap;
ofstream*foot;
string htitle;
string hauthor;
int chapno;
string chapnumber;
string chapname;
string qchapnumber,qchapname;
string chtitle;
bool singleFile;
string footdocname;
int footnum;
int footnest;
bool fitalics,fquoth;
bool breakPending;
int footnotePad;
queue<string> chapterCache;
int indexline,chapline,footline;
deque<string> declarationsQueue;
string headingAlign;

string quoteHTMLString(string s);

string translateHTMLString(string t);

void emitq(string s){
emit(translateHTMLString(s));
}

void generateAlignedParagraph(string alignment,char bracket,string text,
string terminator= "<br />");

void writeHTMLDocumentPreamble(ostream&os,string title,int*lineCounter);

void writeHTMLDocumentBodyStart(ostream&os,string title,int*lineCounter);

void writeHTMLDocumentPostamble(ostream&os,int*lineCounter);

static void createNavButton(string button,const unsigned char source[],int length);

static void createNavButtons(void);

void createNavigationPanel(int prev,int next,bool inParagraph= true);

virtual void emit(string s,textComponent*destination= NULL){
if(singleFile){
*index<<s<<"\n";
indexline++;
}else{
if(infoot||(chap==NULL)){
*(infoot?foot:index)<<s<<"\n";
if(infoot){
footline++;
}else{
indexline++;
}
}else{
chapterCache.push(s+"\n");
}
}
lineNumber++;
}

static string pruneIndent(string s){
assert(s!="");
return s.substr(s.find_first_not_of(' '));
}

static string elideNewLines(string s){
string o= s;
unsigned int i;

while((i= o.find('\n'))!=string::npos){
o.replace(i,1," ");
}
while((o.length()> 0)&&(o[o.length()-1]==' ')){
o= o.substr(0,o.length()-1);
}
return o;
}

static unsigned int linesIn(string s){
return count(s.begin(),s.end(),'\n');
}

void flushBreak(void){
if(breakPending){
if(strictCompliance){
emit("<br class=\"cb\" />");
}else{
emit("<br clear=\"all\" />");
}
breakPending= false;
}
}

public:
void setFootnotePad(int fp= defaultFootnotePad){
footnotePad= fp;
}

int getFootnotePad(void){
return footnotePad;
}

HTMLGenerationSink(string bname,bool make_one_file= false){
time_t t= time(NULL);
stime= ctime(&t);
stime= stime.substr(0,stime.length()-1);

italics= inmath= infoot= quoth= false;
hastitle= hasauthor= false;
firstchap= false;
if(bname=="-"){
cerr<<"Cannot write HTML document set to standard output.\n";
exit(1);
}
basename= bname;
singleFile= make_one_file;
index= chap= foot= NULL;
footnum= footnest= 0;
footdocname= "";
setFootnotePad();
breakPending= false;
chapno= 0;
indexline= chapline= footline= 0;
}

virtual~HTMLGenerationSink(){
}

string componentName(void){
return"HTMLGenerationSink";
}

string getBaseName(void){
return basename;
}

void put(string s);
};

/*:91*//*92:*/
#line 182 "html.w"

void HTMLGenerationSink::put(string s){
bodyState state= DecodeBodyState(s[0]);
char bracket= s[1];
string text= s.substr(2);
ostringstream efn;

switch(state){
case BeginText:
indexFileName= basename+".html";
index= new ofstream(indexFileName.c_str(),ios::out);
break;

case Declarations:
/*93:*/
#line 270 "html.w"

if(bracket==Body){
assert(etextBodyParserFilter::isLineSpecial(text));
declarationsQueue.push_back(etextBodyParserFilter::specialCommand(text));
}
break;

/*:93*/
#line 196 "html.w"
;

case DocumentTitle:
/*94:*/
#line 283 "html.w"

switch(bracket){
case Begin:
quoth= false;
htitle= "";
break;

case Body:
if(htitle!=""){
htitle+= " ";
}
htitle+= quoteHTMLString(pruneIndent(text));
hastitle= true;
break;

case Void:
hastitle= false;
htitle= "";
break;
}
break;

/*:94*/
#line 199 "html.w"
;

case Author:
/*95:*/
#line 311 "html.w"

switch(bracket){
case Begin:
quoth= false;
hauthor= "";
break;

case Body:
if(hauthor!=""){
hauthor+= " ";
}
hauthor+= quoteHTMLString(pruneIndent(text));
break;

case End:
hasauthor= true;


case Void:
/*96:*/
#line 340 "html.w"

writeHTMLDocumentPreamble(*index,htitle,&indexline);
writeHTMLDocumentBodyStart(*index,htitle,&indexline);
*index<<"<div class=\"bodycopy\">\n";
indexline++;
if(hastitle){
*index<<"<h1 "<<headingAlign<<">"<<translateHTMLString(htitle)<<"</h1>\n";
indexline++;
}
if(hasauthor){
*index<<"<h2 "<<headingAlign<<">"<<translateHTMLString(hauthor)<<"</h2>\n";
indexline++;
}

/*:96*/
#line 330 "html.w"
;
break;
}
break;

/*:95*/
#line 202 "html.w"
;

case ChapterNumber:
/*97:*/
#line 358 "html.w"

switch(bracket){
case Begin:
chapnumber= "";
break;

case Body:
chapnumber+= quoteHTMLString(pruneIndent(text))+"\n";
break;

case Void:
chapnumber= "";


case End:
break;
}
break;

/*:97*/
#line 205 "html.w"
;

case ChapterName:
/*98:*/
#line 383 "html.w"

switch(bracket){
case Begin:
chapname= "";
break;

case Body:
chapname+= quoteHTMLString(pruneIndent(text))+"\n";
break;

case Void:
chapname= "";


case End:
flushBreak();
if(singleFile){
/*99:*/
#line 418 "html.w"

*index<<"<h2 "<<headingAlign<<" style=\"margin-left: 5%; margin-right: 5%;\">\n";
indexline++;
if(chapnumber!=""){
*index<<translateHTMLString(chapnumber);
indexline+= linesIn(chapnumber);
}
if(((chapname!="")||(chapname!=""))||
((chapname=="")&&(chapname==""))){
*index<<"</h2>\n";
if(strictCompliance){
*index<<"<hr class=\"s\" />\n";
}else{
*index<<"<hr width=\"25%\" size=\"2\" noshade=\"noshade\" />\n";
}
*index<<"<h2 "<<headingAlign<<" style=\"margin-left: 5%; margin-right: 5%;\">\n";
indexline+= 3;
}
if(chapname!=""){
*index<<translateHTMLString(chapname);
indexline+= linesIn(chapname);
}
*index<<"</h2>\n";
indexline++;

/*:99*/
#line 400 "html.w"
;
}else{
/*100:*/
#line 453 "html.w"

/*101:*/
#line 508 "html.w"

if(chap!=NULL){
string s;

writeHTMLDocumentPreamble(*chap,chtitle,&chapline);
*chap<<"<link href=\""<<indexFileName<<"\" rel=\"parent\" rev=\"child\" />\n";
chapline++;
if(chapno> 1){
*chap<<"<link href=\""<<basename<<"_chap"<<(chapno-1)<<".html"<<
"\" rel=\"prev\" rev=\"next\" />\n";
chapline++;
}
if(state!=EndOfText){
*chap<<"<link href=\""<<basename<<"_chap"<<(chapno+1)<<".html"<<
"\" rel=\"next\" rev=\"prev\" />\n";
chapline++;
}
writeHTMLDocumentBodyStart(*chap,chtitle,&chapline);
if(hastitle){
if(strictCompliance){
*chap<<"<table class=\"chfile\">\n";
*chap<<"<tr><td class=\"l\">&nbsp;</td>\n";
*chap<<"<td class=\"m\"><h1>"<<htitle<<"</h1></td>\n";
*chap<<"<td class=\"r\">\n";
}else{
*chap<<"<table width=\"100%\">\n";
*chap<<"<tr><td width=\"25%\" valign=\"top\">&nbsp;</td>\n";
*chap<<"<td width=\"50%\" align=\"center\"><h1>"<<htitle<<"</h1></td>\n";
*chap<<"<td width=\"25%\" align=\"right\">\n";
}
createNavigationPanel(chapno-1,(state==EndOfText)?0:(chapno+1),false);
*chap<<"</td></tr></table>\n";
chapline+= 5;
}else{
createNavigationPanel(chapno-1,(state==EndOfText)?0:(chapno+1));
}
*chap<<"<div class=\"bodycopy\">\n";
*chap<<"<h1 "<<headingAlign<<" style=\"margin-left: 5%; margin-right: 5%;\">\n";
chapline+= 2;
if(qchapnumber!=""){
*chap<<translateHTMLString(qchapnumber);
chapline+= linesIn(qchapnumber);
}
if(((qchapname!="")||(qchapname!=""))||
((qchapname=="")&&(qchapname==""))){
*chap<<"</h1>\n";
if(strictCompliance){
*chap<<"<hr class=\"s\" />\n";
}else{
*chap<<"<hr width=\"25%\" size=\"2\" noshade=\"noshade\" />\n";
}
*chap<<"<h1 "<<headingAlign<<" style=\"margin-left: 5%; margin-right: 5%;\">\n";
chapline+= 3;
}
if(qchapname!=""){
*chap<<translateHTMLString(qchapname);
chapline+= linesIn(qchapname);
}
*chap<<"</h1>\n";
*chap<<"\n";
chapline+= 2;
while(!chapterCache.empty()){
*chap<<chapterCache.front();
chapline++;
chapterCache.pop();
}
*chap<<"</div>\n";
chapline+= 2;
createNavigationPanel(chapno-1,(state==EndOfText)?0:(chapno+1));
writeHTMLDocumentPostamble(*chap,&chapline);
chap->close();
if(verbose){
cerr<<basename<<"_chap"<<chapno<<".html: "<<chapline<<" lines.\n";
}
}

/*:101*/
#line 454 "html.w"
;
if(chapno==0){
createNavButtons();
if(strictCompliance){
*index<<"<table class=\"ctable\">\n";
}else{
*index<<"<table width=\"80%\" align=\"center\">\n";
}
indexline++;
}
chapno++;
chapline= 0;
efn<<basename<<"_chap"<<chapno<<".html";
chap= new ofstream(efn.str().c_str(),ios::out);
chtitle= htitle;
if(chapnumber!=""){
chtitle+= ": ";
chtitle+= chapnumber;
}
qchapnumber= chapnumber;
qchapname= chapname;



if(strictCompliance){
*index<<"<tr><th><a href=\""<<efn.str()<<"\">";
}else{
*index<<"<tr><th align=\"right\" width=\"15%\"><a href=\""<<efn.str()<<"\">";
}
if(chapnumber==""){
*index<<chapno<<".";
}else{
*index<<elideNewLines(chapnumber);
indexline+= linesIn(elideNewLines(chapnumber));
}
if(strictCompliance){
*index<<"</a></th> <td class=\"space\">&nbsp;</td> <td class=\"name\"><a href=\""
<<efn.str()<<"\">"<<
translateHTMLString(elideNewLines(chapname))<<"</a></td></tr>\n";
}else{
*index<<"</a></th> <td width=\"5%\">&nbsp;</td> <td width=\"80%\"><a href=\""
<<efn.str()<<"\">"<<
translateHTMLString(elideNewLines(chapname))<<"</a></td></tr>\n";
}
indexline+= linesIn(elideNewLines(chapname))+1;

/*:100*/
#line 402 "html.w"
;
}
break;
}
break;

/*:98*/
#line 208 "html.w"
;

case InTextParagraph:
generateAlignedParagraph("justify",bracket,text,"");
break;

case InBlockQuote:
generateAlignedParagraph("quote",bracket,text,"");
break;

case InRaggedRight:
generateAlignedParagraph("left",bracket,text);
break;

case InRaggedLeft:
generateAlignedParagraph("right",bracket,text);
break;

case InPreformattedTable:
generateAlignedParagraph("table",bracket,text,"");
break;

case InCentred:
generateAlignedParagraph("center",bracket,text);
break;

case EndOfText:
if(!singleFile){
*index<<"</table>\n";
indexline++;
}
*index<<"</div>\n";
indexline++;
writeHTMLDocumentPostamble(*index,&indexline);
index->close();
/*101:*/
#line 508 "html.w"

if(chap!=NULL){
string s;

writeHTMLDocumentPreamble(*chap,chtitle,&chapline);
*chap<<"<link href=\""<<indexFileName<<"\" rel=\"parent\" rev=\"child\" />\n";
chapline++;
if(chapno> 1){
*chap<<"<link href=\""<<basename<<"_chap"<<(chapno-1)<<".html"<<
"\" rel=\"prev\" rev=\"next\" />\n";
chapline++;
}
if(state!=EndOfText){
*chap<<"<link href=\""<<basename<<"_chap"<<(chapno+1)<<".html"<<
"\" rel=\"next\" rev=\"prev\" />\n";
chapline++;
}
writeHTMLDocumentBodyStart(*chap,chtitle,&chapline);
if(hastitle){
if(strictCompliance){
*chap<<"<table class=\"chfile\">\n";
*chap<<"<tr><td class=\"l\">&nbsp;</td>\n";
*chap<<"<td class=\"m\"><h1>"<<htitle<<"</h1></td>\n";
*chap<<"<td class=\"r\">\n";
}else{
*chap<<"<table width=\"100%\">\n";
*chap<<"<tr><td width=\"25%\" valign=\"top\">&nbsp;</td>\n";
*chap<<"<td width=\"50%\" align=\"center\"><h1>"<<htitle<<"</h1></td>\n";
*chap<<"<td width=\"25%\" align=\"right\">\n";
}
createNavigationPanel(chapno-1,(state==EndOfText)?0:(chapno+1),false);
*chap<<"</td></tr></table>\n";
chapline+= 5;
}else{
createNavigationPanel(chapno-1,(state==EndOfText)?0:(chapno+1));
}
*chap<<"<div class=\"bodycopy\">\n";
*chap<<"<h1 "<<headingAlign<<" style=\"margin-left: 5%; margin-right: 5%;\">\n";
chapline+= 2;
if(qchapnumber!=""){
*chap<<translateHTMLString(qchapnumber);
chapline+= linesIn(qchapnumber);
}
if(((qchapname!="")||(qchapname!=""))||
((qchapname=="")&&(qchapname==""))){
*chap<<"</h1>\n";
if(strictCompliance){
*chap<<"<hr class=\"s\" />\n";
}else{
*chap<<"<hr width=\"25%\" size=\"2\" noshade=\"noshade\" />\n";
}
*chap<<"<h1 "<<headingAlign<<" style=\"margin-left: 5%; margin-right: 5%;\">\n";
chapline+= 3;
}
if(qchapname!=""){
*chap<<translateHTMLString(qchapname);
chapline+= linesIn(qchapname);
}
*chap<<"</h1>\n";
*chap<<"\n";
chapline+= 2;
while(!chapterCache.empty()){
*chap<<chapterCache.front();
chapline++;
chapterCache.pop();
}
*chap<<"</div>\n";
chapline+= 2;
createNavigationPanel(chapno-1,(state==EndOfText)?0:(chapno+1));
writeHTMLDocumentPostamble(*chap,&chapline);
chap->close();
if(verbose){
cerr<<basename<<"_chap"<<chapno<<".html: "<<chapline<<" lines.\n";
}
}

/*:101*/
#line 243 "html.w"
;
if(foot!=NULL){
*foot<<"</div>\n";
footline++;
writeHTMLDocumentPostamble(*foot,&footline);
foot->close();
if(verbose){
cerr<<footdocname<<": "<<footline<<" lines.\n";
}
}
if(verbose){
cerr<<indexFileName<<": "<<indexline<<" lines.\n";
}
break;

default:
cerr<<"*** State "<<stateNames[state]<<" "<<bracket<<
" not handled in HTMLGenerationSink ***\n";
exit(1);
}
}

/*:92*//*102:*/
#line 591 "html.w"

void HTMLGenerationSink::generateAlignedParagraph(string alignment,char bracket,string text,
string terminator){
string s;

switch(bracket){
case Begin:
emit("");
if(alignment=="quote"){
emit("<blockquote>");
if(strictCompliance){
emit("<div class=\"quote\">");
}
}else if(alignment=="table"){
emit("<pre>");
}else{
if(strictCompliance){
emit("<p class=\""+alignment+"\">");
}else{
emit("<p align=\""+alignment+"\">");
}
}
break;

case Body:
if(etextBodyParserFilter::isLineSpecial(text)){
emit(etextBodyParserFilter::specialCommand(text));
}else{
s= translateHTMLString(text);
if(!infoot){
s+= terminator;
}
emit(s);
}
break;

case End:
if(alignment=="quote"){
if(strictCompliance){
emit("</div>");
}
emit("</blockquote>");
}else if(alignment=="table"){
emit("</pre>");
}else{
emit("</p>");
}
break;

case Void:
break;
}
}

/*:102*//*103:*/
#line 656 "html.w"

string HTMLGenerationSink::quoteHTMLString(string s)
{
string::iterator cp;
string o= "";

for(cp= s.begin();cp<s.end();cp++){
int c= (*cp)&0xFF;

switch(c){
case'&':
o+= "&amp;";
break;

case'<':
o+= "&lt;";
break;

case'>':
o+= "&gt";
break;

default:
if(c<' '){
/*104:*/
#line 699 "html.w"

if(isspace(c)){
o+= c;
}else{
o+= "^"+('@'+c);
}

/*:104*/
#line 680 "html.w"
;
}else{
if(unicodeChars){
/*105:*/
#line 710 "html.w"

if(!inmath&&(c=='-')&&((cp+1)<s.end())&&(cp[1]=='-')){
/*106:*/
#line 727 "html.w"

o+= "&mdash;";
cp++;

/*:106*/
#line 712 "html.w"
;
}else if(!inmath&&(c=='.')&&((cp+2)<s.end())&&
(cp[1]=='.')&&(cp[2]=='.')){
/*107:*/
#line 735 "html.w"

o+= "&hellip;";
cp+= 2;
/*:107*/
#line 715 "html.w"
;
}else if(!inmath&&c=='"'){
/*108:*/
#line 746 "html.w"

o+= quoth?"&rdquo;":"&ldquo;";
quoth= !quoth;

/*:108*/
#line 717 "html.w"
;
}else{
o+= c;
}

/*:105*/
#line 683 "html.w"

}else{
o+= c;
}
}
break;
}
}
return o;
}

/*:103*//*109:*/
#line 758 "html.w"

string HTMLGenerationSink::translateHTMLString(string t)
{
string::iterator cp;
string o= "";
char c;
static const string punctuation= PUNCTUATION;
string s= quoteHTMLString(t);

for(cp= s.begin();cp<s.end();cp++){
c= *cp;

if(!inmath&&c=='_'){
/*110:*/
#line 795 "html.w"

italics= !italics;
if(italics){
o+= "<i> ";
}else{
o+= "</i>";
}

/*:110*/
#line 771 "html.w"
;
}else if(c=='\\'&&((cp+1)<s.end())&&((cp[1]=='(')||(cp[1]==')'))){
/*111:*/
#line 812 "html.w"

inmath= cp[1]=='(';
cp++;
if(inmath){
if(strictCompliance){
o+= "<table class=\"math\"><tr><td>";
}else{
o+= "<table bgcolor=\"#FFA0A0\"><tr><td>";
}
}else{
o+= "</td></tr></table>";
}

/*:111*/
#line 773 "html.w"
;
}else if(!inmath&&((cp+2)<s.end())&&
((c=='[')||((c==' ')&&(cp[1]=='['))||
((c==' ')&&(cp[1]==' ')&&(cp[2]=='[')))){
/*112:*/
#line 842 "html.w"

#define NETSCRAPE_SUCKS          
if(footnest> 0){
issueMessage("Cannot nest footnotes in HTML document output.");
if(strictCompliance){
o+= "<span class=\"footnote\">[";
o+= "<span class=\"foottext\">";
}else{
o+= "<span style=\"background-color: #FFFFA0\">[<small>";
o+= "<font face=\"Helvetica, Arial\">";
}
}else{
if(singleFile){
#ifdef NETSCRAPE_SUCKS
if(strictCompliance){
o+= "<span class=\"footnote\">[";
o+= "<span class=\"foottext\">";
}else{
o+= "<span style=\"background-color: #FFFFA0\">[<small>";
o+= "<font face=\"Helvetica, Arial\">";
}
#else
flushBreak();
if(strictCompliance){
o+= "<sup>*</sup>\n<table class=\"footnote\">\n";
o+= "<tr><td><b>*</b> <small>\n";
}else{
o+= "<sup>*</sup>\n<table width=\"25%\" "
"align=\"right\" hspace=\"6\" bgcolor=\"#FFFFD0\">\n";
o+= "<tr><td><b>*</b> <small>\n";
}
#endif
}else{
ostringstream eflink;

/*114:*/
#line 962 "html.w"

if(foot==NULL){
footdocname= basename+"_foot"+".html";
foot= new ofstream(footdocname.c_str(),ios::out);
writeHTMLDocumentPreamble(*foot,htitle+": Notes",&footline);
writeHTMLDocumentBodyStart(*foot,htitle+": Notes",&footline);
*foot<<"<div class=\"bodycopy\">\n";
footline++;
}

/*:114*/
#line 877 "html.w"
;
footnum++;
if(strictCompliance){
eflink<<"<a href=\""<<footdocname<<"#"<<footnum<<
"\" rel=\"Target:"<<basename<<"_foot\">"<<
"<sup>"<<footnum<<"</sup></a>";
}else{
eflink<<"<a href=\""<<footdocname<<"#"<<footnum<<
"\" target=\""<<basename<<"_foot\">"<<
"<sup>"<<footnum<<"</sup></a>";
}
o+= eflink.str();
emit(o);
o= "";
infoot= true;
eflink.str("");
eflink<<"<a name=\""<<footnum<<"\">"<<footnum<<".</a> ";
o+= eflink.str();
}
fitalics= italics;
fquoth= quoth;
italics= quoth= false;
}
if((c==' ')&&((cp+1)<s.end())){
if(cp[1]==' '){
cp++;
}
cp++;
}
footnest++;

/*:112*/
#line 777 "html.w"
;
}else if(!inmath&&c==']'){
/*113:*/
#line 915 "html.w"

if(footnest==1){
if(singleFile){
#ifdef NETSCRAPE_SUCKS
if(strictCompliance){
o+= "</span>]</span>";
}else{
o+= "</font></small>]</span>";
}
#else
o+= "\n</small>\n</table>\n";
#endif
breakPending= true;
}else{
int l;

emit(o);
emit("<p />");
emit("<pre>");
for(l= 0;l<footnotePad;l++){
emit("");
}
emit("</pre>");
o= "";
infoot= false;
}
italics= fitalics;
quoth= fquoth;
}else if(footnest> 1){
if(strictCompliance){
o+= "</span>]</span>";
}else{
o+= "</font></small>]</span>";
}
}
if(footnest==0){
issueMessage("Mismatched end of footnote (\"]\") bracket.");
}else{
footnest--;
}

/*:113*/
#line 779 "html.w"
;
}else{
if(c=='&'){
/*115:*/
#line 979 "html.w"

o+= c;
while(++cp<s.end()){
c= *cp;
o+= c;
if(c==';'){
break;
}
}

/*:115*/
#line 782 "html.w"

}else{
/*116:*/
#line 994 "html.w"

if(!inmath&&frenchPunct&&((c&0xFF)==C_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)
&&(cp!=s.end())&&(!isspace(cp[1]))){
o+= c;
o+= "&nbsp;";
}else if(!inmath&&frenchPunct&&(punctuation.find_first_of(c)!=string::npos)&&
(((cp+1)==s.end())||isspace(cp[1])||
((cp[1]&0xFF)==C_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)||(cp[1]==','))){
o+= "&nbsp;";
o+= c;
}else{
o+= c;
}

/*:116*/
#line 784 "html.w"
;
}
}
}
return o;
}

/*:109*//*117:*/
#line 1012 "html.w"

void HTMLGenerationSink::writeHTMLDocumentPreamble(ostream&os,string title,int*lineCounter){
int preambleLines= 13;
deque<string> ::iterator decl;

if(strictCompliance){
os<<"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\"\n";
os<<"    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">\n";
}else{
os<<"<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n";
os<<"    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
}
os<<"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n";
os<<"<!--  Translated by "PRODUCT" "VERSION
" ("REVDATE") on "+stime+"-->\n";
os<<"<head>\n";
os<<"<title>"<<title<<"</title>\n";
os<<"<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\" />\n";
if(hastitle){
os<<"<meta name=\"description\" content=\""<<elideNewLines(title)<<"\" />\n";
preambleLines+= 1;
}
if(hasauthor){
os<<"<meta name=\"author\" content=\""<<elideNewLines(hauthor)<<"\" />\n";
preambleLines+= 1;
}
os<<"<style type=\"text/css\">\n";
os<<"div.bodycopy {\n";
os<<"    margin-left: 15%;\n";
os<<"    margin-right: 10%\n";
os<<"}\n";

headingAlign= "align=\"center\"";
if(strictCompliance){
headingAlign= "class=\"c\"";
os<<"\n";

os<<"body {\n";
os<<"    background-color: #FFFFFF;\n";
os<<"    color: #000000;\n";
os<<"}\n\n";

os<<"br.cb {\n";
os<<"    clear: both;\n";
os<<"}\n\n";

os<<"h1.c, h2.c {\n";
os<<"    text-align: center;\n";
os<<"}\n\n";

os<<"hr.s {\n";
os<<"    width: 25%;\n";
os<<"    height: 2px;\n";
os<<"    background-color: #000000;\n";
os<<"    color: #010101;\n";
os<<"}\n\n";

os<<"img.m0 {\n";
os<<"    vertical-align: middle;\n";
os<<"    border: 0px;\n";
os<<"}\n\n";

os<<"p.justify {\n";
os<<"    text-align: justify;\n";
os<<"}\n\n";

os<<"p.right {\n";
os<<"    text-align: right;\n";
os<<"}\n\n";

os<<"p.center {\n";
os<<"    text-align: center;\n";
os<<"}\n\n";

os<<"span.footnote {\n";
os<<"    background-color: #FFFFA0;\n";
os<<"    color: #000000;\n";
os<<"}\n\n";

os<<"span.foottext {\n";
os<<"    font-family: Helvetica, Arial, sans-serif;\n";
os<<"    font-size: smaller;\n";
os<<"}\n\n";

os<<"table.chfile {\n";
os<<"    width: 100%;\n";
os<<"}\n\n";

os<<"table.chfile td.l {\n";
os<<"    width: 25%;\n";
os<<"    vertical-align: top;\n";
os<<"}\n\n";

os<<"table.chfile td.m {\n";
os<<"    width: 50%;\n";
os<<"    text-align: center;\n";
os<<"}\n\n";

os<<"table.chfile td.r {\n";
os<<"    width: 25%;\n";
os<<"    text-align: right;\n";
os<<"}\n\n";

os<<"table.ctable {\n";
os<<"    width: 80%;\n";
os<<"    margin-left: auto;\n";
os<<"    margin-right: auto;\n";
os<<"}\n\n";

os<<"table.ctable th {\n";
os<<"    width: 15%;\n";
os<<"    text-align: right;\n";
os<<"}\n\n";

os<<"table.ctable td.space {\n";
os<<"    width: 5%;\n";
os<<"}\n\n";

os<<"table.ctable td.name {\n";
os<<"    width: 80%;\n";
os<<"}\n\n";

os<<"table.footnote {\n";
os<<"    color: #000000;\n";
os<<"    background-color: #FFFFD0;\n";
os<<"    width: 25%;\n";
os<<"    float: right;\n";
os<<"    margin-left: 6px;\n";
os<<"}\n\n";

os<<"table.math {\n";
os<<"    color: #000000;\n";
os<<"    background-color: #FFA0A0;\n";
os<<"}\n";

preambleLines+= 98;
}
os<<"</style>\n";

/*118:*/
#line 1175 "html.w"

if(strictCompliance&&(!singleFile)){
os<<"<script type=\"text/javascript\">\n";
os<<"/* <![CDATA[ */\n";
os<<"    function externalLinks() {\n";
os<<"        if (!document.getElementsByTagName) {\n";
os<<"            return;\n";
os<<"        }\n";
os<<"        var anchors = document.getElementsByTagName(\"a\");\n";
os<<"        for (var i = 0; i < anchors.length; i++) {\n";
os<<"            var anchor = anchors[i], target;\n";
os<<"            if (anchor.getAttribute(\"href\") &&\n";
os<<"                anchor.getAttribute(\"rel\") &&\n";
os<<"                anchor.getAttribute(\"rel\").match(/^Target:/)) {\n";
os<<"                target = anchor.getAttribute(\"rel\")."
"match(/(^Target:)(\\w+$)/);\n";
os<<"                anchor.target = target[2];\n";
os<<"            }\n";
os<<"        }\n";
os<<"    }\n";
os<<"/* ]]> */\n";
os<<"</script>\n";
preambleLines+= 19;
}

/*:118*/
#line 1151 "html.w"


*lineCounter+= preambleLines;

for(decl= declarationsQueue.begin();decl!=declarationsQueue.end();decl++){
os<<*decl<<"\n";
*lineCounter+= 1;
}
}

/*:117*//*119:*/
#line 1205 "html.w"

void HTMLGenerationSink::writeHTMLDocumentBodyStart(ostream&os,string title,int*lineCounter){
const int bodyStartLines= 3;

os<<"</head>\n";
os<<"\n";
if(strictCompliance){
if(singleFile){
os<<"<body>\n";
}else{
os<<"<body onload=\"externalLinks();\">\n";
}
}else{
os<<"<body bgcolor=\"#FFFFFF\">\n";
}
*lineCounter+= bodyStartLines;
}

/*:119*//*120:*/
#line 1227 "html.w"

void HTMLGenerationSink::writeHTMLDocumentPostamble(ostream&os,int*lineCounter){
const int postambleLines= 2;

os<<"</body>\n";
os<<"</html>\n";
*lineCounter+= postambleLines;
}

/*:120*//*121:*/
#line 1250 "html.w"

void HTMLGenerationSink::createNavigationPanel(int prev,int next,bool inParagraph)
{


if(inParagraph){
if(strictCompliance){
*chap<<"<p class=\"right\">\n";
}else{
*chap<<"<p align=\"right\">\n";
}
chapline++;
}
if(prev!=0){
if(strictCompliance){
*chap<<"<a href=\""<<basename<<"_chap"<<prev<<".html\">"<<
"<img class=\"m0\" src=\"prev.png\" "
"height=\"32\" width=\"32\" alt=\"Previous\" /></a> &nbsp; &nbsp;\n";
}else{
*chap<<"<a href=\""<<basename<<"_chap"<<prev<<".html\">"<<
"<img align=\"middle\" src=\"prev.png\" "
"height=\"32\" width=\"32\" border=\"0\" alt=\"Previous\" /></a> &nbsp; &nbsp;\n";
}
}else{
if(strictCompliance){
*chap<<"<img class=\"m0\" src=\"prev_gr.png\" "
"height=\"32\" width=\"32\" alt=\"\" /> &nbsp; &nbsp;\n";
}else{
*chap<<"<img align=\"middle\" src=\"prev_gr.png\" "
"height=\"32\" width=\"32\" border=\"0\" alt=\"\" /> &nbsp; &nbsp;\n";
}
}
chapline++;



if(strictCompliance){
*chap<<"<a href=\""<<basename<<".html\"> <img class=\"m0\" src=\"up.png\" "
"height=\"32\" width=\"32\" alt=\"Contents\" /></a> &nbsp; &nbsp;\n";
}else{
*chap<<"<a href=\""<<basename<<".html\"> <img align=\"middle\" src=\"up.png\" "
"height=\"32\" width=\"32\" border=\"0\" alt=\"Contents\" /></a> &nbsp; &nbsp;\n";
}
chapline++;



if(next!=0){
if(strictCompliance){
*chap<<"<a href=\""<<basename<<"_chap"<<next<<".html\">"<<
"<img class=\"m0\" src=\"next.png\" "
"height=\"32\" width=\"32\" alt=\"Next\" /></a>\n";
}else{
*chap<<"<a href=\""<<basename<<"_chap"<<next<<".html\">"<<
"<img align=\"middle\" src=\"next.png\" "
"height=\"32\" width=\"32\" border=\"0\" alt=\"Next\" /></a>\n";
}
}else{
if(strictCompliance){
*chap<<"<img class=\"m0\" src=\"next_gr.png\" "
"height=\"32\" width=\"32\" alt=\"\" />\n";
}else{
*chap<<"<img align=\"middle\" src=\"next_gr.png\" "
"height=\"32\" width=\"32\" border=\"0\" alt=\"\" />\n";
}
}
chapline++;

if(inParagraph){
*chap<<"</p>\n";
chapline++;
}
}


/*:121*//*122:*/
#line 1330 "html.w"

void HTMLGenerationSink::createNavButtons(void){
/*124:*/
#line 1374 "html.w"

#include "buttons.h"
#line 1 "palm.w"
/*:124*/
#line 1332 "html.w"
;

#ifdef FOOTNOTE_BUTTON_NEEDED
createNavButton("foot",d_foot,sizeof d_foot);
#endif
createNavButton("next",d_next,sizeof d_next);
createNavButton("prev",d_prev,sizeof d_prev);
createNavButton("up",d_up,sizeof d_up);
createNavButton("next_gr",d_next_gr,sizeof d_next_gr);
createNavButton("prev_gr",d_prev_gr,sizeof d_prev_gr);
}

/*:122*//*123:*/
#line 1353 "html.w"

void HTMLGenerationSink::createNavButton(string button,const unsigned char source[],int length)
{
string buttonFile;
ofstream*bf;

buttonFile= button+".png";
bf= new ofstream(buttonFile.c_str(),ios::out|ios::binary);
bf->write(reinterpret_cast<const char*> (source),length);
bf->close();
}

/*:123*//*125:*/
#line 6 "palm.w"

class PalmGenerationFilter:public textFilter{
private:
bool italics,inmath,quoth,hastitle,hasauthor,
infoot,intable,firstchap;
string htitle;
string hauthor;
string chapnumber;
string chapname;
string partext;
int parline;
int chapno;
int footnum;
int footnest;
string footnotes;
string footpar;
string footsave;
bool fitalics,fquoth;
textSubstituter transformer;

string quotePalmString(string s);

static string pruneIndent(string s){
assert(s!="");
return s.substr(s.find_first_not_of(' '));
}

virtual void emit(string s,textComponent*destination= NULL){
if(infoot){
footnotes+= s+"\n";
}else{
textFilter::emit(s,destination);
}
}

void emitq(string s){
emit(quotePalmString(s));
}

void generateFilledParagraph(bodyState state,string envtype,
char bracket,string text);

void generateAlignedParagraph(bodyState state,string envtype,
char bracket,string text);

bool isSubstitution(string cmd);

public:
PalmGenerationFilter(){
italics= inmath= quoth= false;
hastitle= hasauthor= false;
intable= firstchap= infoot= false;
footnest= footnum= 0;
chapno= 0;
}

virtual~PalmGenerationFilter(){
}

string componentName(void){
return"PalmGenerationFilter";
}

void put(string s);
};

/*:125*//*126:*/
#line 80 "palm.w"

void PalmGenerationFilter::put(string s){
bodyState state= DecodeBodyState(s[0]);
char bracket= s[1];
string text= s.substr(2);

switch(state){
case BeginText:
/*127:*/
#line 156 "palm.w"

{
time_t t= time(NULL);
string stime= ctime(&t);
stime= stime.substr(0,stime.length()-1);

emit("\\v Translated by "PRODUCT" "VERSION" ("REVDATE") on "+stime+"\\v");
}
break;

/*:127*/
#line 88 "palm.w"
;

case Declarations:
/*128:*/
#line 172 "palm.w"

if(bracket==Body){
assert(etextBodyParserFilter::isLineSpecial(text));
if(!isSubstitution(text)){
emit(etextBodyParserFilter::specialCommand(text));
}
}
break;


/*:128*/
#line 91 "palm.w"
;

case DocumentTitle:
/*129:*/
#line 188 "palm.w"

switch(bracket){
case Begin:
htitle= "";
break;

case Body:
if(htitle!=""){
htitle+= " ";
}
htitle+= quotePalmString(pruneIndent(text));
hastitle= true;
break;

case Void:
hastitle= false;
htitle= "";
break;
}
break;

/*:129*/
#line 94 "palm.w"
;

case Author:
/*130:*/
#line 217 "palm.w"

switch(bracket){
case Begin:
hauthor= "";
break;

case Body:
if(hauthor!=""){
hauthor+= " ";
}
hauthor+= quotePalmString(pruneIndent(text));
break;

case End:
hasauthor= true;


case Void:
if(hastitle){
emit("\\vTITLE=\""+htitle+"\"\\v");
emit("\\c\\b"+htitle+"\\b");
emit("\\c");
}
if(hasauthor){
emit("\\c"+hauthor);
emit("\\c");
}
break;
}
break;

/*:130*/
#line 97 "palm.w"
;

case ChapterNumber:
/*131:*/
#line 252 "palm.w"

switch(bracket){
case Begin:
chapnumber= "";
break;

case Body:
if(chapnumber!=""){
chapnumber+= " ";
}
chapnumber+= quotePalmString(pruneIndent(text));
break;

case Void:
chapnumber= "";


case End:
break;
}
break;

/*:131*/
#line 100 "palm.w"
;

case ChapterName:
/*132:*/
#line 283 "palm.w"

switch(bracket){
case Begin:
chapname= "";
break;

case Body:
if(chapname!=""){
chapname+= " ";
}
chapname+= quotePalmString(pruneIndent(text));
break;

case Void:
chapname= "";


case End:
chapno++;
emit("");
if((chapname!="")||(chapnumber!="")){
string s= "\\x\\b";

if(chapnumber!=""){
s+= chapnumber;
if(chapname!=""){
s+= ": ";
}
}
emit(s+chapname+"\\b\\x");
}else{
ostringstream numchap;

numchap<<"\\x\\b\\a151 "<<chapno<<"\\a151\\b\\x";
emit(numchap.str());
}
break;
}
break;

/*:132*/
#line 103 "palm.w"
;

case InTextParagraph:
generateFilledParagraph(state,"",bracket,text);
break;

case InBlockQuote:
generateFilledParagraph(state,"\\t",bracket,text);
break;

case InRaggedRight:
generateAlignedParagraph(state,"",bracket,text);
break;

case InRaggedLeft:
generateAlignedParagraph(state,"\\r",bracket,text);
break;

case InPreformattedTable:
if(bracket==Begin){
intable= true;
}
generateAlignedParagraph(state,"",bracket,text);
if(bracket==End){
intable= false;
}
break;

case InCentred:
generateAlignedParagraph(state,"\\c",bracket,text);
break;

case EndOfText:
if(footnum> 0){
emit(footnotes);
}
if(verbose){
cerr<<"Palm: "<<
(getLineNumber()+count(footnotes.begin(),footnotes.end(),'\n'))<<
" lines output.\n";
}
break;

default:
cerr<<"*** State "<<stateNames[state]<<" "<<bracket<<
" not handled in PalmGenerationFilter ***\n";
exit(1);
}
}

/*:126*//*133:*/
#line 332 "palm.w"

void PalmGenerationFilter::generateFilledParagraph(bodyState state,string envtype,
char bracket,string text){
string s;

switch(bracket){
case Begin:
emit("");
quoth= false;
partext= "";
break;

case Body:
if(etextBodyParserFilter::isLineSpecial(text)){
if(!isSubstitution(text)){
partext+= etextBodyParserFilter::specialCommand(text);
}
}else{
s= quotePalmString(pruneIndent(text));
if(infoot){
if(footpar!=""){
footpar+= ' ';
}
footpar+= s;
}else{
if(partext==""){
partext= envtype;
}else{
partext+= ' ';
}
partext+= s;
}
}
break;

case End:
emit(partext+envtype);
break;

case Void:
break;
}
}

/*:133*//*134:*/
#line 391 "palm.w"

void PalmGenerationFilter::generateAlignedParagraph(bodyState state,string envtype,
char bracket,string text){
string s,l;

switch(bracket){
case Begin:
emit("");
quoth= false;
parline= 0;
break;

case Body:
s= "";
if(parline==0){
s= envtype;
}
if(etextBodyParserFilter::isLineSpecial(text)){
if(!isSubstitution(text)){
s+= etextBodyParserFilter::specialCommand(text);
}else{
break;
}
}else{
if(state==InPreformattedTable){
l= quotePalmString(text.substr((text.substr(0,2)=="  ")?2:0));
}else{
l= quotePalmString(pruneIndent(text));
}
if(infoot){
if(footpar!=""){
footpar+= ' ';
}
footpar+= l;
break;
}else{
s+= l;
}
}
emit(s);
parline++;
break;

case End:
emit(envtype);
break;

case Void:
break;
}
}

/*:134*//*135:*/
#line 456 "palm.w"

string PalmGenerationFilter::quotePalmString(string s)
{
string::iterator cp;
string o= "";
int c;
static const string punctuation= "?!:;";

for(cp= s.begin();cp<s.end();cp++){
c= (*cp)&0xFF;

if(c<' '){
/*136:*/
#line 508 "palm.w"

if(isspace(c)){
o+= c;
}else{
o+= "^";
o+= ('@'+c);
}

/*:136*/
#line 468 "palm.w"
;
}else if((c>=160)&&(c<=255)){
/*137:*/
#line 524 "palm.w"

ostringstream isochar;

isochar<<"\\a"<<setw(3)<<setfill('0')<<c;

if(!inmath&&frenchPunct&&(c==C_LEFT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)&&
(cp!=s.end())&&(!isspace((cp[1]&0xFF)))){
o+= isochar.str();
o+= "\\a160";
}else if(!inmath&&frenchPunct&&(c==C_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)&&
(cp!=s.begin())){
o+= "\\a160";
o+= isochar.str();
}else{
o+= isochar.str();
}

/*:137*/
#line 470 "palm.w"
;
}else if(c>=' '&&c<='~'){
if(!inmath&&!intable&&c=='_'){
/*138:*/
#line 545 "palm.w"

italics= !italics;
if(italics){
o+= "\\i";
}else{
o+= "\\i";
}

/*:138*/
#line 473 "palm.w"
;
}else if(!intable&&c=='\\'&&
((cp+1)<s.end())&&((cp[1]=='(')||(cp[1]==')'))){
/*139:*/
#line 565 "palm.w"

inmath= cp[1]=='(';
o+= "\\\\";

/*:139*/
#line 476 "palm.w"
;
}else if(c=='\\'){
o+= "\\\\";
}else if(!inmath&&!intable&&((cp+2)<s.end())&&
((c=='[')||((c==' ')&&(cp[1]=='['))||
((c==' ')&&(cp[1]==' ')&&(cp[2]=='[')))){
/*140:*/
#line 586 "palm.w"

footnest++;
if(footnest> 1){
issueMessage("Cannot nest footnotes in Palm Markup Language output.");
o+= "[";
}else{
ostringstream flink;

footnum++;
flink<<"\\Q=\"b"<<footnum<<"\"\\q=\"#f"<<footnum<<"\"["<<footnum<<"]\\q";
o+= flink.str();
footsave= o;
infoot= true;
fitalics= italics;
fquoth= quoth;
italics= quoth= false;
o= "";
footpar= "";
if(footnum==1){
emit("\\x\\a185 \\a178 \\a179 \\a133\\x");
}
flink.str("");
flink<<"\\p\\Q=\"f"<<footnum<<"\"";
emit(flink.str());
}
if((c==' ')&&((cp+1)<s.end())){
if(cp[1]==' '){
cp++;
}
cp++;
}

/*:140*/
#line 482 "palm.w"
;
}else if(!inmath&&!intable&&c==']'){
/*141:*/
#line 627 "palm.w"

if(footnest==0){
issueMessage("Mismatched end of footnote (\"]\") bracket.");
}else{
footnest--;
if(footnest> 0){
o+= ']';
}else{
ostringstream blink;

if(o!=""){
if(footpar!=""){
footpar+= ' ';
}
footpar+= o;
}
blink<<"\\b"<<footnum<<".\\b  ";
emit(blink.str()+footpar);
blink.str("");
blink<<"\\c\\l\\q=\"#b"<<footnum<<"\"<<<\\q\\l";
emit(blink.str());
emit("\\c");
infoot= false;
italics= fitalics;
quoth= fquoth;
o= footsave;
}
}

/*:141*/
#line 484 "palm.w"
;
}else if(!inmath&&!intable&&(c=='-')&&((cp+1)<s.end())&&(cp[1]=='-')){
/*142:*/
#line 661 "palm.w"

o+= "\\a151";
cp++;

/*:142*/
#line 486 "palm.w"
;
}else if(!inmath&&!intable&&(c=='.')&&((cp+2)<s.end())&&
(cp[1]=='.')&&(cp[2]=='.')){
/*143:*/
#line 669 "palm.w"

o+= "\\a133";
cp+= 2;

/*:143*/
#line 489 "palm.w"
;
}else if(!inmath&&!intable&&c=='"'){
/*144:*/
#line 681 "palm.w"

o+= quoth?"\\a148":"\\a147";
quoth= !quoth;

/*:144*/
#line 491 "palm.w"
;
}else{
/*145:*/
#line 691 "palm.w"

if(!inmath&&frenchPunct&&(punctuation.find_first_of(c)!=string::npos)&&
(((cp+1)==s.end())||(cp[1]==' ')||
((cp[1]&0xFF)==C_RIGHT_POINTING_DOUBLE_ANGLE_QUOTATION_MARK)||(cp[1]==','))){
o+= "\\a160";
o+= c;
}else{
if(intable||(c!=' ')||(o=="")||(o[o.length()-1]!=' ')){
o+= c;
}
}

/*:145*/
#line 493 "palm.w"
;
}
}


}
o= transformer.substitute(o);
return o;
}

/*:135*//*146:*/
#line 707 "palm.w"

bool PalmGenerationFilter::isSubstitution(string cmd)
{
string s= etextBodyParserFilter::specialCommand(cmd);
bool isSub= false,bogus= true;
unsigned int n,m,l;
char delim;

if(s.find("Substitute ")==0){
isSub= true;
s= s.substr(11);
n= s.find_first_not_of(' ');
if(n!=string::npos){
delim= s[n];
m= s.find(delim,n+1);
if(m!=string::npos){
l= s.find(delim,m+1);
if(l!=string::npos){
bogus= false;
transformer.addSubstitution(s.substr(n+1,(m-n)-1),
s.substr(m+1,(l-m)-1));
}
}
}
if(bogus){
issueMessage("Invalid Palm Substitute special",cerr);
issueMessage(auditFilter::quoteArbitraryString(cmd),cerr);
}
}
return isSub;
}
#line 2197 "etset.w"

/*:146*/
#line 205 "etset.w"

/*147:*/
#line 2205 "etset.w"

int main(int argc,char*argv[])
{
int i,f= 0,opt;
char*cp;

/*154:*/
#line 2489 "etset.w"

static const struct option long_options[]= {
{"ascii-only",0,NULL,210},
{"babel",1,NULL,202},
{"check",0,NULL,209},
{"clean",0,NULL,208},
{"copyright",0,NULL,200},
{"debug-parser",1,NULL,205},
{"dos-characters",0,NULL,213},
{"flatten-iso",0,NULL,212},
{"french-punctuation",0,NULL,203},
{"help",0,NULL,'u'},
{"html",0,NULL,'h'},
{"latex",0,NULL,'l'},
{"palm",0,NULL,'p'},
{"save-epilogue",1,NULL,206},
{"save-prologue",1,NULL,207},
{"single-file",0,NULL,204},
{"special-strip",0,NULL,211},
{"strict",0,NULL,214},
{"unicode",0,NULL,215},
{"verbose",0,NULL,'v'},
{"version",0,NULL,201},
{0,0,0,0}
};
int option_index= 0;

while((opt= getopt_long(argc,argv,"hlpuv",long_options,&option_index))!=-1){
switch(opt){
case 210:
asciiOnly= true;
break;

case 202:
babelon= true;
babelang= optarg;
break;

case 209:
checkText= true;
break;

case 208:
cleanText= true;
break;

case 200:
cout<<"This program is in the public domain.\n";
return 0;

case 205:
debugParser= true;
debugParserFile= optarg;
break;

case 213:
dosCharacters= true;
break;

case 212:
flattenISOchars= true;
break;

case 203:
frenchPunct= true;
break;

case'h':
ofmt= HTML;
break;

case'l':
ofmt= LaTeX;
break;

case'p':
ofmt= Palm;
break;

case 206:
saveEpilogueFile= optarg;
break;

case 207:
savePrologueFile= optarg;
break;

case 204:
singleFileHTML= true;
break;

case 211:
specialStrip= true;
break;

case 214:
strictCompliance= true;
break;

case 215:
unicodeChars= true;
break;

case'u':
case'?':
usage();
return 0;

case'v':
verbose= true;
break;

case 201:
cout<<PRODUCT" "VERSION"\n";
cout<<"Last revised: "REVDATE"\n";
cout<<"The latest version is always available\n";
cout<<"at http://www.fourmilab.ch/etexts/etset\n";
cout<<"Please report bugs to bugs@fourmilab.ch\n";
return 0;

default:
cerr<<"***Internal error: unhandled case "<<opt<<" in option processing.\n";
return 1;
}
}

/*:154*/
#line 2211 "etset.w"
;
/*156:*/
#line 2629 "etset.w"

for(i= optind;i<argc;i++){
cp= argv[i];
switch(f){
case 0:
infile= cp;
f++;
break;

case 1:
outfile= cp;
f++;
break;

default:
cerr<<"Too many file names arguments specified.\n";
return 2;
}
}

if((ofmt==HTML)&&((f<2)||(outfile=="-"))){
cerr<<"Must specify output file name for HTML.\n";
return 2;
}

/*157:*/
#line 2673 "etset.w"

if((ofmt!=HTML)&&(f==2)&&(infile!="-")&&(outfile!="-")){
bool io_dup= false;

if(infile==outfile){
io_dup= true;
#ifdef HAVE_STAT
}else{
struct stat instat,outstat;

if((stat(infile.c_str(),&instat)==0)&&
(stat(outfile.c_str(),&outstat)==0)&&
(instat.st_dev==outstat.st_dev)&&
(instat.st_ino==outstat.st_ino)){
io_dup= true;
}
#endif
}
if(io_dup){
cerr<<"Input and output may not be the same file.\n";
return 2;
}
}

/*:157*/
#line 2654 "etset.w"
;

/*:156*/
#line 2212 "etset.w"
;

streamSource insource;
trimFilter tfilt;
tabExpanderFilter tabf(8);
flattenISOCharactersFilter*fiso;
convertForeignCharacterSetToISOFilter*dosconv;
auditFilter afilt(FormatWidth);
sectionSeparatorSquid squiddley;
etextBodyParserFilter bodyParser;
stripSpecialCommandsFilter*ssc;
LaTeXGenerationFilter*lf;
PalmGenerationFilter*pf;
streamSink*os= NULL;
heatSink*hs;
HTMLGenerationSink*hgs;

#define Plumb(component)    *pipeEnd | component; pipeEnd =  &component

try{
insource.openFile(infile);
}catch(invalid_argument&e){
cerr<<e.what()<<"\n";
return 2;
}
textComponent*pipeEnd= &insource;
if(dosCharacters){
insource.setStripEOL(true);
dosconv= new convertForeignCharacterSetToISOFilter(cp850_to_ISO);
Plumb(*dosconv);
}
if(!checkText){
Plumb(tfilt);
Plumb(tabf);
}
if(specialStrip){
ssc= new stripSpecialCommandsFilter;
Plumb(*ssc);
}
if(flattenISOchars){
fiso= new flattenISOCharactersFilter;
Plumb(*fiso);
}
if(cleanText||checkText){
afilt.setAuditCriteria(auditFilter::trailing_blanks|
auditFilter::embedded_tabs|
auditFilter::exceeds_maximum_length|
auditFilter::invalid_characters|
auditFilter::special_commands_present|
(asciiOnly?0:auditFilter::permit_8_bit_ISO_characters));
Plumb(afilt);
if(checkText){
hs= new heatSink;
Plumb(*hs);
}else{
os= new streamSink(outfile);
Plumb(*os);
}
}else{
Plumb(squiddley);
/*148:*/
#line 2329 "etset.w"

textComponent*prodest= NULL;

if(savePrologueFile!=""){
squiddley.setPrologueProcessor(prodest= new streamSink(savePrologueFile));
}
if(saveEpilogueFile!=""){
if(savePrologueFile==saveEpilogueFile){
squiddley.setEpilogueProcessor(prodest);
}else{
squiddley.setEpilogueProcessor(new streamSink(saveEpilogueFile));
}
}

/*:148*/
#line 2272 "etset.w"
;

if(asciiOnly){
afilt.disableAuditCriteria(auditFilter::permit_8_bit_ISO_characters);
}
Plumb(afilt);
afilt.disableAuditCriteria(auditFilter::special_commands_present);

Plumb(bodyParser);

/*149:*/
#line 2351 "etset.w"

if(debugParser){
parserDiagnosticFilter*pd= new parserDiagnosticFilter;
streamSink*pdsink= new streamSink(debugParserFile);
teeSquid*pdtsq= new teeSquid(pd);

*pd|*pdsink;
Plumb(*pdtsq);
}

/*:149*/
#line 2282 "etset.w"
;

if(ofmt==LaTeX){
lf= new LaTeXGenerationFilter;
os= new streamSink(outfile);

bodyParser.setSpecialFilter("LaTeX");
Plumb(*lf);
Plumb(*os);
}else if(ofmt==HTML){
hgs= new HTMLGenerationSink(outfile,singleFileHTML);

bodyParser.setSpecialFilter("HTML");
Plumb(*hgs);
}else if(ofmt==Palm){
pf= new PalmGenerationFilter;
os= new streamSink(outfile);

bodyParser.setSpecialFilter("Palm");
Plumb(*pf);
Plumb(*os);
}
}

insource.send();

if(verbose){
cerr<<insource.getSourceLineNumber()<<" input lines processed.\n";
}

if(os!=NULL){
delete os;
}

return 0;
}

/*:147*/
#line 206 "etset.w"


/*:6*/
#line 196 "etset.w"


/*:5*/
