
%    Input format definition

\centerline{\titlefont
                      Beautifully Typeset Etexts
}

\vskip 4ex

Plain Vanilla Etexts don't have to be austere and
typographically uninviting. Most literature (as opposed to 
scientific publications, for  example),  is 
typographically simple and can be rendered beautifully
into type without encoding it into proprietary word
processor file formats or impenetrable markup languages.
Etexts may be encoded in a form which permits them to be 
both read directly (Plain Vanilla) and typeset in 
a form virtually indistinguishable from printed editions of
the work.

To create ``typographically friendly'' Etexts, observe the
following rules:

\medskip
\item{1.} Characters follow the 8-bit ISO 8859/1 Latin-1
	character set.  ASCII is a proper subset of this
	character set, so any ``Plain ASCII'' file meets ths
	criterion by definition.  The extension to ISO 8859/1
	is required so that Etexts which include the
	accented characters used by Western European
	languages may continue to be ``readable by both humans
	and computers''.

\medskip
\item{2.} No white space characters other than blanks 
	and line separators are used (in particular, 
	tabs are expanded to spaces).


\medskip
\item{3.}  The text bracket sequence:\par
\centerline{\.{<><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><><>}}
\par
\item{}	appears both before and after the actual body of the 
	Etext.  This allows including an arbitrary prologue and
	epilogue to the body of the document.


\medskip
\item{4.} Normal body text begins in column 1 and is set 
	ragged right with a line length of 70 
	characters.  The choice of 70 characters is arbitrary
	and was made to avoid overly long and therefore less
	readable lines in the Plain Vanilla text.


\medskip
\item{5.}  Paragraphs are separated by blank lines.


\medskip
\item{6.} Centring, right, and left justification is 
	indicated by actually so-justifying the text within
	the 70 character line.  Left justified lines should 
	start in column 2 to avoid confusion with paragraph
	body text.


\medskip
\item{7.} Block quotations are indented to start in column
	5 and set ragged right with a line length of 60
	characters.
	

\medskip
\item{8.} Preformatted tables begin with a line which starts
	in column 3 and contains at least one sequence of
	three or more spaces between nonblanks.  The table is
	formatted verbatim until the next blank line.


\medskip
\item{9.} Text set in italics is bracketed by underscore 
	characters, ``\\{\_}''.  These must match.


\medskip
\item{10.} Footnotes are included in-line, bracketed by ``\.{[}~\.{]}''.
	The footnote appears at the point in the copy where the
	footnote mark appears in the source text.  Footnotes
	may not be nested and may consist of only a single
	paragraph.


\medskip
\item{11.} The title is defined as the sequence of lines
	which appear between the first text bracket
	``\.{<><><>}$\ldots$'' and a centred line consisting
	exclusively of three or more equal signs ``\.{====}''.


\medskip
\item{12.} The author's name is the text which follows the
	line of equal signs marking the end of the title and 
	precedes the first chapter mark.  This may be
	multiple lines.


\medskip
\item{13.} Chapters are delimited by a three line sequence 
	of centred lines:

\centerline{\it Chapter number}
\centerline{\.{--------------------}}
\centerline{\it Chapter name}

\item{}	The line of minus signs must be centred and contain
	three or more minus signs and no other characters apart
	from white space.  Chapter ``numbers'' need not be
	numeric---they can be any text.

\medskip
\item{14.} Dashes in the text are indicated in the normal typewritten
    	text convention of ``\.{--}''.  No hyphenation of words at the end
    	of lines is done.


\medskip
\item{15.} Ellipses are indicated by ``\.{...}'';
	sentence-ending ellipses by ``\.{....}''.

\medskip
\item{16.} Greek letters and mathematical symbols are enclosed
    in the brackets ``\.{\\(}'' and ``\.{\\)}'' and are
    expressed as their character or symbol names in the \LaTeX\
    typesetting language.  For example, write the Greek word for
    ``word'': $\lambda \acute{o} \gamma o \varsigma$ as:

\hskip 12em\begingroup
\verbatim
                \( \lambda \acute{o} \gamma o \varsigma \)
!endgroup
\endgroup

\item{} and the formula for the roots of a quadratic equation as:

\hskip 12em\begingroup
\verbatim
                \( x_{1,2} = \frac{-b \pm \sqrt{b^2 - 4ac}}{2a} \)
!endgroup
\endgroup

\item{}	I acknowledge that this provision is controversial.  It
	is as distasteful to me as I suspect it is to you.  In
	its defence, let me treat the Greek letter and math
	formula cases separately. Using \LaTeX\ encoding for
	Greek letters is purely a stopgap until Unicode comes
	into common use on enough computers so that we can use
	it for Etexts  which contain characters not in the
	ASCII or ISO 8859/1 sets (which are the 7- and 8-bit
	subsets of Unicode, respectively).  If an author uses a
	Greek word in the text, we have two ways to proceed in
	attempting to meet the condition:

{\leftskip 48pt\rightskip 48pt\medskip\noindent
    	The etext, when displayed, is clearly readable, and
    	does {\it not} contain characters other than those
    	intended by the author of the work, although$\ldots$.
\medskip}

\item{}	The first approach is to transliterate into Roman
	characters according to a standard table such as 
	that given in {\it The Chicago Manual of 
	Style}.  This preserves readability and doesn't
	require funny encoding, but in a sense violates the
	author's ``original intent''---the author 
	could have transliterated the word in the first
	place but chose not to.  By transliterating we're
	reversing the author's decision.  The second 
	approach, encoding in \LaTeX\ or some other
	markup language, preserves the distinction that the
	author wrote the word in Greek and maintains 
	readability since letters are called out by their
	English language names, for the most part.  Of course
	\LaTeX\ helps us only for Greek (and a few characters
	from other languages).  If you're faced with Cyrillic,
	Arabic, Chinese, Japanese, or other languages
	written in non-Roman letters, the only option
	(absent Unicode) is to transliterate.

\item{}	I suggest that encoding mathematical formulas as \LaTeX\ 
	achieves the goal of ``readable by humans'' on the
	strength of \LaTeX\ encoding being widely used in 
	the physics and mathematics communities when 
	writing formulas in E-mail and other ASCII media. 
	Just as one is free to to transliterate Greek in an
	Etext, one can use ASCII artwork formulas like:

\begingroup
\verbatim
!                                           ---------
!                                      +   /  2
!                                   -b - \/  b  - 4ac
!                         x     =  ------------------
!                          1,2            2a
!endgroup
\endgroup

\item{}	This is probably a better choice for occasional
	formulas simple enough to write out this way.  But to
	produce Etexts of historic scientific 
	publications such as Einstein's ``{\it Zur
	Elektrodynamik bewegter K\"orper}'' (the special
	relativity paper published in {\it Annalen der
	Physik} in 1905), trying to render dozens of
	complicated equations in ASCII is not only
	extremely tedious but in all likelihood
	counter-productive; ambiguities in trying to express
	complex equations would make it difficult for a
	reader to determine precisely what Einstein wrote
	unless conventions just as complicated (and harder 
	to learn) as those of \LaTeX\ were adopted for ASCII
	expression of mathematics.  Finally, the choice of
	\LaTeX\ encoding is made not only based on its
	existing widespread use but because the underlying
	software that defines it (\TeX\ and \LaTeX) are
	entirely in the public domain, available in source
	code form, implemented on most commonly-available
	computers, and frozen by their authors so that,
	unlike many commercial products, the syntax is
	unlikely to change in the future and obsolete
	current texts.


\medskip
\item{17.} Other punctuation in the text consists only of the
    	characters:

\hskip 8em\begingroup
\verbatim
           . , : ; ? !! ` ' ( ) { } " + = - / * @@ # !$ !% & ~ ^ !char124 < >
!endgroup
\endgroup

\item{} In other words, the characters:

\hskip 8em\begingroup
\verbatim
           _ [ ] \
!endgroup
\endgroup

\item{} are never used except in the special senses defined above.


\medskip
\item{18.} Quote marks may be rendered explicitly as open and close
	quote marks with the sequences `single quotes' or
	``double quotes''.  As long as quotes are 
	balanced within a paragraph, the ASCII quote character
	`\.{"}' may be used.  Alternating occurrences of
	this character will be typeset as open and
	close quote characters. The open/close quote state
	is reset at the start of each paragraph, limiting
	the scope of errors to a single paragraph and
	permitting ``continuation quotes'' when multiple
	paragraphs are quoted.
