#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 821  2021-11-15 15:15


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    use Crypt::Random::Seed;
    use Getopt::Long;
    use JSON;
    use LWP::Simple;
    use List::Util qw(shuffle);
    use Math::Random::MT;
    use Text::CSV qw(csv);

    use constant SATOSHI => 0.00000001;
    use constant ERRFLAG => " ****";

    my $APIretry = 3;                   # Maximum attempts to make API query
    my $ignoreZero = FALSE;             # Ignore zero balance addresses
    my $dust = 0.001;                   # Don't report balance increases less than this
    my $loop = FALSE;                   # Loop forever checking addresses
    my $shuffle = FALSE;                # Shuffle order of address queries
    my $sortrep = FALSE;                # Restore original order of shuffled queries in report
    my $verbose = FALSE;                # Show all queries, not just alerts
    my $waitconst = 17;                 # Constant wait between queries, seconds
    my $waitloop = 3600;                # Wait between series of queries
    my $waitrand = 20;                  # Random wait between queries, seconds

    #   Bitcoin data sources
    my $srcBTC = "blockchain.info";
    my %btcSource = (
        "blockchain.info"   =>  \&s_b_blockchain,
        "blockcypher.com"   =>  \&s_b_blockcypher,
        "btc.com"           =>  \&s_b_btc
    );

    #   Ethereum data sources
    my $srcETH = "blockchain.com";
    my %ethSource = (
        "blockchain.com"    =>  \&s_e_blockchain,
        "etherscan.io"      =>  \&s_e_etherscan,
        "ethplorer.io"      =>  \&s_e_ethplorer
    );

    randInit();

    GetOptions(
        "btcsource=s"   =>  \$srcBTC,
        "dust=f"        =>  \$dust,
        "ethsource=s"   =>  \$srcETH,
        "help"          =>  \&showHelp,
        "loop"          =>  \$loop,
        "retry=i",      =>  \$APIretry,
        "shuffle"       =>  \$shuffle,
        "sort"          =>  \$sortrep,
        "verbose"       =>  \$verbose,
        "waitconst=f"   =>  \$waitconst,
        "waitloop=f"    =>  \$waitloop,
        "waitrand=f"    =>  \$waitrand,
        "zero"          =>  \$ignoreZero
    ) || die("Command line option error");

    #   Validate address query source specifications

    if (!defined($btcSource{$srcBTC})) {
        print("Unknown Bitcoin query source.\n");
        exit(2);
    }

    if (!defined($ethSource{$srcETH})) {
        print("Unknown Ethereum query source.\n");
        exit(2);
    }

    my $csv = Text::CSV->new({ binary => 1 }) ||
        die("Cannot use CSV: " . Text::CSV->error_diag());

    my $adrs = [ ];
    my %adrOrder;
    my $addrn = 0;
    while (my $l = <>) {
        chomp($l);
        $l =~ s/^\s+//;
        $l =~ s/\s+$//;
        if (($l ne "") && ($l !~ m/^#/)) {
            if ($csv->parse($l)) {
                $addrn++;
                push(@$adrs, [ $csv->fields, 0 ]);
                if ($sortrep && (!$adrOrder{($csv->fields())[1]})) {
                    $adrOrder{($csv->fields())[1]} = $addrn;
                }
           }
        }
    }

    my ($balErrs, $APIerrs);

    do {
        my @repRec;
        if ($shuffle) {
            @$adrs = shuffle(@$adrs);
        }

        ($balErrs, $APIerrs) = (0, 0);
        for (my $i = 0; $i < scalar(@$adrs); $i++) {
            my ($label, $bcaddr, $balance, $tries) =
                ($adrs->[$i][0], $adrs->[$i][1], $adrs->[$i][3], $adrs->[$i][4]);
            if ((!$ignoreZero) || ($balance > 0)) {
                $balance += 0;
                my $warn = "";
                my $cbal;
                my $cbalf;
                if ($bcaddr =~ m/^0x/i) {
                    $cbal = $ethSource{$srcETH}($bcaddr);
                } else {
                    $cbal = $btcSource{$srcBTC}($bcaddr);
                }
                if (defined($cbal)) {

                    my $bdiff = $cbal - $balance;
                    $cbalf = sprintf("%16.8f", $cbal);
                    if ($bdiff < -(SATOSHI)) {
                         $warn = ERRFLAG;
                         $balErrs++;
                    } elsif ($bdiff > SATOSHI) {
                         $warn = ($cbal < ($balance + $dust)) ? " Dust" : ERRFLAG;
                    }
                } else {

                    $cbalf = " " x 16;
                    $tries++;
                    if ($tries < $APIretry) {
                        if ($verbose) {
                            $warn = " API fail, try $tries/$APIretry";
                        }
                        push(@$adrs, [ $label, $bcaddr, $adrs->[$i][2], $balance, $tries ]);
                    } else {
                        $warn = " API failure";
                        $APIerrs++;
                    }
                }
                if ($verbose || ($warn ne "")) {
                    my $rl = sprintf("%-12s  %-42s  %16.8f  %s%s",
                               $label, $bcaddr, $balance, $cbalf, $warn);
                    if ($shuffle && $sortrep) {
                        #   Sorting addresses: save result record
                        push(@repRec, "$bcaddr,$rl");
                    } else {
                        print("$rl\n");
                    }
                }
                if ($i < (scalar(@$adrs) - 1)) {
                    sleep($waitconst + randNext($waitrand));
                }
            }
        }
        if ($shuffle && $sortrep) {
            #   Sort results in order addresses were specified
            foreach my $rs (sort(byOrderSpecified @repRec)) {
                $rs =~ s/^\w+,//;
                print("$rs\n");
            }
            @repRec = ();
        }
        if ($loop && ($waitloop > 0)) {
            sleep($waitloop);
        }
    } while ($loop);

    exit(($balErrs > 0) ? 1 : (($APIerrs > 0) ? 2 : 0));

    sub showHelp {
        my $btcsites = join(", ", sort(keys(%btcSource)));
        my $ethsites = join(", ", sort(keys(%ethSource)));
        my $help = <<"EOD";
perl cold_comfort.pl [ options... ] address_file...
  Options:
    -btcsource site     Site to query for Bitcoin balances: $btcsites
    -dust n             Ignore "dust" sent to address less than n units
    -ethsource site     Site to query for Ethereum balances: $ethsites
    -help               Print this message
    -loop               Loop forever polling addresses
    -retry n            Try failed API query requests n times
    -shuffle            Shuffle order in which addresses queried
    -sort               Restore order of shuffled queries in report
    -verbose            Show all polls, regardless of error status
    -waitconst n        Wait constant n seconds between queries
    -waitloop n         Wait n seconds between re-polls in -loop
    -waitrand n         Wait random time 0 to n seconds between address polls
    -zero               Ignore addresses with zero expected balance
EOD
        print($help);
        exit(0);
    }

    
        use Math::Random::MT;

        my $randGen;                    # Pseudorandom number generator

        sub randInit {
            if (!defined($randGen)) {
                my (@seed, $rbuf);

                my $rgen = Crypt::Random::Seed->new(NonBlocking => 1);
                $rbuf = $rgen->random_bytes(624 * 4);
                @seed = unpack("L4", $rbuf);
                $randGen = Math::Random::MT->new(@seed);
            }
        }
    
        sub randNext {
            my ($n) = @_;

            return $randGen->rand($n);
        }
    

    sub byOrderSpecified {
        $a =~ m/^(\w+),/;
        my $aAddr = $1;
        $b =~ m/^(\w+),/;
        my $bAddr = $1;
        return $adrOrder{$aAddr} <=> $adrOrder{$bAddr};
    }

    sub s_b_blockcypher {
        my ($address) = @_;

        my $balance;
        my $reply = get("https://api.blockcypher.com/v1/btc/main/addrs/$address/balance");
        if (defined($reply)) {
            my $r = decode_json($reply);
            $balance = $r->{balance} * SATOSHI;
        }

        return $balance;
    }

    sub s_b_blockchain {
        my ($address) = @_;

        my $balance = get("https://blockchain.info/q/addressbalance/$address");

        if (defined($balance)) {
            $balance *= SATOSHI;
        }

        return $balance;
    }

    sub s_b_btc {
        my ($address) = @_;

        my $balance;

        my $request = LWP::UserAgent->new();
        $request->agent("cold_comfort");
        my $response = $request->get("https://btc.com/btc/search?q=$address");
        if ($response->is_success) {
            my $reply = $response->content;
            if ($reply =~ m:Balance</div><div\s+class="ant-col\s+ant-col-24\s+text-c">([\d\.\,]+)\s+BTC</div>:) {
                $balance = $1;
                $balance =~ s:[,<>/b]::g;
                $balance = $balance + 0;
            }
        }

        return $balance;
    }

    sub s_e_blockchain {
        my ($address) = @_;

        my $balance;
        my $reply = get("https://www.blockchain.com/eth/address/$address");
        if (defined($reply)) {
            if ($reply =~ m/The\s+current\s+value\s+of\s+this\s+address\s+is\s+([\d\.,]+)\s+ETH/) {
                $balance = $1;
                $balance =~ s/,//g;
                $balance = $balance + 0;
            }
        }

        return $balance;
    }

    sub s_e_etherscan {
        my ($address) = @_;

        my $balance;
        my $request = LWP::UserAgent->new();
        $request->agent("cold_comfort");
        my $response = $request->get("https://etherscan.io/address/$address");
        if ($response->is_success) {
            my $reply = $response->content;
            if ($reply =~ m:<div\s+class="col\-md\-8">([\d\.,<>/b]+)\s+Ether</div>:) {
                $balance = $1;
                $balance =~ s:[,<>/b]::g;
                $balance = $balance + 0;
            }
        }

        return $balance;
    }

    sub s_e_ethplorer {
        my ($address) = @_;

        my $balance;
        my $reply = get("https://api.ethplorer.io/getAddressInfo/$address?apiKey=freekey");
        if (defined($reply)) {
            my $r = decode_json($reply);
            if ($r->{address} eq lc($address)) {
                $balance = $r->{ETH}->{balance};
            }
        }

        return $balance;
    }
