#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 821  2021-11-15 15:15


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    use Crypt::SSSS;
    use Digest::SHA qw(sha256 sha256_hex);
    use List::Util qw(shuffle);
    use Text::CSV qw(csv);
    use POSIX qw(log10);
    use Getopt::Long;

    my $basename = "";                  # Base name for generated files
    my $join = FALSE;                   # Join parts into complete keys
    my $prime = 257;                    # Prime used to set security
    my $parts = 3;                      # Number of shared keys to generate
    my $needed = 3;                     # Shared keys to reassemble address

    GetOptions(
        "help"      =>  \&showHelp,
        "join"      =>  \$join,
        "name=s"    =>  \$basename,
        "needed=i"  =>  \$needed,
        "parts=i"   =>  \$parts,
        "prime=i"   =>  \$prime
    ) || die("Command line option error");

    my $csv = Text::CSV->new({ binary => 1 }) ||
        die("Cannot use CSV: " . Text::CSV->error_diag());

    if ($basename eq "") {
        if ((scalar(@ARGV) > 0) && ($ARGV[0] ne "")) {
            $basename = $ARGV[0];
            $basename =~ s/\.\w*$//;
        }
        if ($basename eq "") {
            $basename = $join? "joined_keys-1" : "shared_keys";
        }
    }

    my @records;
    my $naddrs = 0;
    while (my $l = <>) {
        chomp($l);
        $l =~ s/^\s+//;
        $l =~ s/\s+$//;
        if (($l ne "") && ($l !~ m/^#/)) {
            my $extra;
            if (($l !~ m/\s*\-1,/) && ($l =~ s/^([^,]+,[^,]+,[^,]+)(,.*)$/$1/)) {
                $extra = $2;
            }
            if ($csv->parse($l)) {
                $naddrs++;
                my @fields = $csv->fields;
                if ($extra) {
                    $fields[3] = $extra;
                }
                push(@records, \@fields);
           }
        }
    }

    if ($join) {
        exit(joinParts());
    }

    my $fnd = int(log10($parts)) + 1;
    my @files;
    for (my $f = 1; $f <= $parts; $f++) {
        my $fnx = sprintf("%s-%0${fnd}d.csv", $basename, $f);
        open($files[$f], ">$fnx") || die("Cannot create $fnx");
        $files[$f]->printf("-1,$parts,$needed,$prime,$f\n");
    }

    my $fail = 0;

    for (my $r = 0; $r < scalar(@records); $r++) {

        my $privkey = chr(32 + length($records[$r]->[2])) . $records[$r]->[2];
        $privkey .= compCheck($privkey);

        my $shares = ssss_distribute(
            message =>  $privkey,
            k       =>  $needed,
            n       =>  $parts,
            p       =>  $prime
        );

        my @hexpart;
        for (my $f = 1; $f <= $parts; $f++) {
            my $hexcheck = sprintf("S%0${fnd}d-%s", $f,
                unpack("H*", $shares->{$f}->binary));
            $hexcheck .= compCheck($hexcheck);
            push(@hexpart, $hexcheck);
            my $extra = $records[$r]->[3] ? $records[$r]->[3] : "";
            $files[$f]->printf("%s,\"%s\",\"%s\"%s\n", $records[$r]->[0],
                $records[$r]->[1], $hexcheck, $extra);
        }

        for (my $l = 0; $l < $parts; $l++) {

            #   Shuffle order of parts before reconstruction
            @hexpart = shuffle(@hexpart);

            #   Perform reconstruction of key from groups of shuffled parts

            for (my $p = 0; $p <= ($parts - $needed); $p++) {
                my $rkey = { };
                for (my $q = $p; $q < ($p + $needed); $q++) {
                    my ($pstat, $pno, $hxp) =  parsePart($hexpart[$q]);
                    if ($pstat < 0) {
                        die("Cannot parse hex part $q " .
                            "$hexpart[$q]: ($pstat, $pno, $hxp)\n");
                    }
                    #   Unpack the hex part payload to bytes and save in parts hash
                    $rkey->{$pno} = pack('C*',  map({ hex($_) } ($hxp =~ /(..)/g)));
                }
                my $rpk = ssss_reconstruct(p => $prime, shares => $rkey);
                my ($kstat, $privad) = parseKey($rpk);
                if (!$kstat) {
                    die("Bad checksum in reconstructed record: $rpk\n  $privad");
                }
                if ($records[$r]->[2] ne $privad) {
                    $fail++;
                    printf(STDERR "** Reconstruction failure on key %d, " .
                        "parts %d through %d:\n   Exp: (%s)\n   Rcv: (%s)\n",
                        $r, ($p + 1), ($p + $needed), $records[$r]->[2], $privad);
                }
            }
        }
    }

    for (my $f = 1; $f <= $parts; $f++) {
        close($files[$f]);
    }

    #   If errors were detected, delete part files to avoid tragedy
    if ($fail > 0) {
        print(STDERR "Failures to reconstruct keys from parts: $fail.\n" .
                     "  Deleting part files.\n");
        for (my $f = 1; $f <= $parts; $f++) {
            unlink(sprintf("%s-%0${fnd}d.csv", $basename, $f));
        }
    }

    exit($fail > 0);

    sub joinParts {
        my $warn = 0;
        my $error = 0;

        my ($restParts, $restNeeded, $restPrime, $restPart);
        my %partsSeen;
        my @addresses;
        my %parts;

        for (my $r = 0; $r < scalar(@records); $r++) {

            #   Test for part definition record and process
            if ($records[$r]->[0] eq "-1") {
                #   Check for inconsistency among parts and save
                #   the part generation parameters.
                if ($restParts && ($restParts != $records[$r]->[1])) {
                    printf("Warning: Record definition for part %d " .
                           "part count %d inconsistent " .
                           "with previous parts (%d).\n",
                           $records[$r]->[4], $records[$r]->[1], $restParts);
                    $warn++;
                } else {
                    $restParts = $records[$r]->[1];
                }

                if ($restNeeded && ($restNeeded != $records[$r]->[2])) {
                    printf("Warning: Record definition for part %d " .
                           "parts needed %d inconsistent " .
                           "with previous parts (%d).\n",
                           $records[$r]->[4], $records[$r]->[2], $restNeeded);
                    $warn++;
                } else {
                    $restNeeded = $records[$r]->[2];
                }

                if ($restPrime && ($restPrime != $records[$r]->[3])) {
                    printf("Warning: Record definition for part %d " .
                           "parts needed %d inconsistent " .
                           "with previous parts (%d).\n",
                           $records[$r]->[4], $records[$r]->[3], $restPrime);
                     $warn++;
               } else {
                    $restPrime = $records[$r]->[3];
                }

                #   Warn if this is a duplicate specification of this part
                $restPart = $records[$r]->[4];
                if ($partsSeen{$restPart}) {
                    printf("Warning: Duplicate specification for part %d.\n", $restPart);
                    $warn++;
                } else {
                    $partsSeen{$restPart} = TRUE;
                }
            } else {

                my ($label, $pubaddr, $partkey, $extra) = ($records[$r]->[0],
                    $records[$r]->[1], $records[$r]->[2], $records[$r]->[3]);
                my ($pstat, $pno, $pvalue) = parsePart($partkey);

                if (!defined($extra)) {
                    $extra = "";
                }

                if ($pstat < 0) {
                    if ($pstat == -1) {
                        printf("Error: cannot parse part %d key: %s\n", $restPart,
                            $partkey);
                    } else {
                        printf("Error: bad checksum in part %d key: %s\n", $restPart,
                            $partkey);
                    }
                    $error++;
                } else {
                    if ($pno != $restPart) {
                        printf("Warning: part number (%d) for address %s " .
                            "differs from part number (%d) in header record.\n",
                            $pno, $pubaddr, $restPart);
                            $warn++;
                    }
                    my $ap = {
                        label   =>  $label,
                        partkey =>  $pvalue,
                        extra   =>  $extra
                    };
                    if (!$parts{$pubaddr}) {
                        $parts{$pubaddr} = [ ];
                        push(@addresses, $pubaddr);
                    }
                    $parts{$pubaddr}->[$restPart] = $ap;
                }
            }
        }

        #   Verify correct number of parts specified
        my $nps = scalar(keys(%partsSeen));
        if ($nps < $restNeeded) {
            printf("Error: fewer parts specified (%s) than needed (%s).\n",
                $nps, $restNeeded);
            $error++;
        } elsif ($nps > $restNeeded) {
            printf("Warning: more parts specified (%s) than needed (%s).\n",
                $nps, $restNeeded);
            $warn++;
        }

        #   Verify that all parts are specified for all addresses
        foreach my $a (@addresses) {
            foreach my $pt (keys(%partsSeen)) {
                if (!($parts{$a}->[$pt])) {
                    print("Error: part $pt missing for address $a.\n");
                    $error++;
                }
            }
        }

        $basename =~ s/\-\d+$//;
        $basename .= "-merged.csv";
        open(FO, ">$basename") ||
            die("Cannot create $basename");
        my $title = "# Private keys assembled from parts ";
        foreach my $pn (sort { $a <=> $b } (keys(%partsSeen))) {
            $title .= "$pn, ";
        }
        $title =~ s/, $/\n/;
        print(FO $title);

        foreach my $a (@addresses) {
            my $rkey = { };
            my $lbl;
            my $rpts = 0;
            foreach my $pt (keys(%partsSeen)) {
                #   Unpack the hex part payload to bytes and save in parts hash
                if (defined($parts{$a}->[$pt])) {
                    my $hxp = $parts{$a}->[$pt]->{partkey};
                    $lbl = $parts{$a}->[$pt]->{label};
                    $rkey->{$pt} = pack('C*',  map({ hex($_) } ($hxp =~ /(..)/g)));
                    $rpts++;
                    #   If more parts were specified than needed, stop
                    #   after we've processed the number required.
                    if ($rpts >= $restNeeded) {
                        last;
                    }
                }
            }
            my $rpk = ssss_reconstruct(p => $prime, shares => $rkey);
            my ($kstat, $privad) = parseKey($rpk);
            if (!$kstat) {
                print("Bad checksum inreconstructed key for $a: $rpk\n  $privad");
                $error++;
            }
            #   We arbitrarily use the extra information from the last
            #   part (all parts should have identical extra information).
            my $ext = $parts{$a}->[-1]->{extra};
            printf(FO "%s,\"%s\",\"%s\"%s\n", $lbl, $a, $privad, $ext);
        }
        close(FO);

        return ($error > 0) ? 2 : (($warn > 0) ? 1 : 0);
    }

    sub parsePart {
        my ($part) = @_;

        $part =~ m/^S(\d+)\-(\w+?)(\w{8})$/ || return (-1, "", "");
        my ($partNumber, $partValue, $checksum) = ($1, $2, $3);
        $partNumber =~ s/^0//g;
        my $rcheck = compCheck(substr($part, 0, -8));
        if ($rcheck ne $checksum) {
            return (-2, $checksum, $rcheck);
        }
        return (TRUE, $partNumber, $partValue);
    }

    sub parseKey {
        my ($rpk) = @_;

        my $rlen = ord(substr($rpk, 0, 1)) - 32;
        my $privad = substr($rpk, 1, $rlen);
        my $cksum = substr($rpk, $rlen + 1, 8);

        my $kcheck = compCheck(substr($rpk, 0, $rlen + 1));
        if ($kcheck ne $cksum) {
            return (FALSE, "$cksum != $kcheck");
        }
        return (TRUE, $privad);
    }

    sub compCheck {
        my ($s) = @_;

        return substr(sha256_hex(sha256($s)), 0, 8);
    }

    sub showHelp {
        my $help = <<"EOD";
perl multi_key.pl [ option... ] file...
  Commands and arguments:
    -help               Print this message
    -join               Join parts and reconstruct keys
    -name filename      Specify name of part or joined key files
    -needed k           Set k parts required to reconstruct keys
    -parts n            Split keys into n parts, of which k are needed
    -prime p            Use p as prime number to encode (super-experts only!)
EOD
        print($help);
        exit(0);
    }
