#! /usr/bin/perl


    #   NOTE: This program was automatically generated by the Nuweb
    #   literate programming tool.  It is not intended to be modified
    #   directly.  If you wish to modify the code or use it in another
    #   project, you should start with the master, which is kept in the
    #   file blockchain_tools.w in the public GitHub repository:
    #       https://github.com/Fourmilab/blockchain_tools.git
    #   and is documented in the file blockchain_tools.pdf in the root directory
    #   of that repository.

    #
    #   Build 821  2021-11-15 15:15


    
        require 5;
        use strict;
        use warnings;
        use utf8;

        use constant FALSE => 0;
        use constant TRUE => 1;
    

    use Text::CSV qw(csv);
    use POSIX qw(strftime);
    use Getopt::Long;
#use Data::Dumper;

    my $date = "";                  #   Date override for address page
    my $fontname = "monospace";     #   Font name for addresses
    my $fontsize = "medium";        #   Font size for addresses
    my $fontweight = "normal";      #   Font weight for addresses
    my $offset = 0;                 #   Add to address numbers in the input file
    my $perpage = 10;               #   Print this number of addresses per page
    my $prefix = "";                #   Prefix the address numbers with this string
    my $separator = "";             #   Separator for address groups
    my $title = "";                 #   Title for page

    GetOptions(
        "date=s"        =>  \$date,
        "font=s"        =>  \$fontname,
        "help"          =>  \&showHelp,
        "offset=i"      =>  \$offset,
        "perpage=i"     =>  \$perpage,
        "prefix=s"      =>  \$prefix,
        "separator=s"   =>  \$separator,
        "size=s"        =>  \$fontsize,
        "title=s"       =>  \$title,
        "weight=s"      =>  \$fontweight
    ) || die("Command line option error");

    my $csv = Text::CSV->new({ binary => 1 }) ||
        die("Cannot use CSV: " . Text::CSV->error_diag());

    #   If no date specified, use current UTC date
    if ($date eq "") {
        $date = strftime("%F", gmtime(time()));
    }

    my $started = FALSE;
    my $inpage = 0;
    my $multipart = FALSE;
    my ($partsn, $partsk, $partsthis);

    my @records;
    my ($naddrs, $npages) = (0, 0);
    while (my $l = <>) {
        chomp($l);
        $l =~ s/^\s+//;
        $l =~ s/\s+$//;
        if (($l ne "") && ($l !~ m/^#/)) {
            if ($csv->parse($l)) {
                $naddrs++;
                my @fields = $csv->fields;
                if (!$started) {
                    if ($fields[0] eq "-1") {
                        $multipart = TRUE;
                        ($partsn, $partsk, $partsthis) = ($fields[1],
                            $fields[2], $fields[4]);
                        $naddrs--;
                        next;
                    }
                    $started = TRUE;
                    if ($title eq "") {
                        $title = (($fields[1] =~ m/^0x/g) ?
                            "Ethereum" : "Bitcoin") . " Wallet";
                    }
                    $npages++;
                } elsif (($perpage > 0) && ($inpage >= $perpage)) {
                    $inpage = 0;
                    $npages++;
                }
                if (($offset != 0) && ($fields[0] =~ m/^\-?\d+$/)) {
                    $fields[0] += $offset;
                }
                $fields[0] = $prefix . $fields[0];
                push(@records, \@fields);
                $inpage++;
           }
        }
    }

    $inpage = 0;
    $started = FALSE;
    my $pageno = 1;
    my $pagetop = TRUE;
    for (my $i = 0; $i < scalar(@records); $i++) {
        if (!$started) {
            HTMLstart($date, $title);
            pageHeader($pageno);
            $started = TRUE;
        } elsif (($perpage > 0) && ($inpage >= $perpage)) {
            pageFooter($pageno, $npages);
            $inpage = 0;
            $pagetop = TRUE;
            $pageno++;
            pageHeader($pageno);
        }
        HTMLrec($pagetop, $records[$i]->[0], $records[$i]->[1], $records[$i]->[2]);
        $pagetop = FALSE;
        $inpage++;
    }

    pageFooter($pageno, $npages);
    HTMLend();

    sub addrFormat {
        my ($addr) = @_;

        if ($separator) {
            my $a = "";
            while ($addr =~ s/^(.+?)(....)$//) {
                $a = "<span class=\"s\"></span>$2$a";
                $addr = $1;
            }
            $addr = "$addr$a";
        }
        return $addr;
    }

    sub pageHeader {
        my ($pageno) = @_;

        my ($multihead, $multistyle) = ("", "");
        if ($multipart) {
            $multihead = "\n        <h4>Part $partsthis of $partsn ($partsk needed)";
            $multistyle = " class=\"multi\"";
        }
        my $headerdiv = ($pageno == 1) ? "firstpage" : "subsequentpage";
        print <<"EOD";
    <div class="$headerdiv">
        <h1>$title</h1>
        <h3$multistyle>$date</h3>$multihead
    </div>
EOD
    }

    sub pageFooter {
        my ($pageno, $ofpages) = @_;

        print <<"EOD";

    <div class="pagefooter">
        <p>Page $pageno of $ofpages</p>
    </div>
EOD
    }

    sub HTMLstart {
        my ($date, $title) = @_;
        print <<"EOD";
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8" />
<title>$title</title>
<style>

    body.standard {
        background-color: #FFFFFF;
        color: #000000;
    }

    div.pagefooter {
        text-align: center;
    }

    div.subsequentpage {
        page-break-before: always;
    }

    table.addr {
        border-collapse: collapse;
        margin-bottom: 1.5ex;
        margin-left: auto;
        margin-right: auto;
    }

    th.num {
        border-bottom: 1px solid black;
        border-right: 1px solid black;
        font-size: 20pt;
        font-weight: bold;
        padding-left: 0.25em;
        padding-right: 0.5em;
        text-align: right;
        width: 12mm;
   }

    tr.priv {
        border-bottom: 1px solid black;
        border-left: 1px solid black;
        border-right: 1px solid black;
    }

    tr.pub {
        border-left: 1px solid black;
        border-right: 1px solid black;
        border-top: 1px solid black;
    }

    td.type {
        font-weight: bold;
        padding-left: 6px;
    }

    td.priv, td.pub {
        font-family: "$fontname";
        font-size: $fontsize;
        font-weight: $fontweight;
        padding-left: 6px;
        padding-right: 6px;
        width: 180mm;
    }


    h1 {
        margin-bottom: 0px;
        text-align: center;
    }

    h3 {
        margin-top: 0px;
        text-align: center;
    }

    h3.multi {
        margin-bottom: 0px;
    }

    h4 {
        margin-top: 0px;
        text-align: center;
    }

    span.s:after {
        font-family: sans-serif;
        content: "";
    }

</style>
</head>

<body class="standard">

EOD
    }

    sub HTMLrec {
        my ($pagetop, $n, $pub, $priv) = @_;

        $pub = addrFormat($pub);
        $priv = addrFormat($priv);
        print <<"EOD";

    <table class="addr">
        <tr class="pub">
            <th class="num" rowspan="2">
                $n
            </th>
            <td class="type">Pub:</td>
            <td class="pub">
                $pub
            </td>
        </tr>
        <tr class="priv">
            <td class="type">Priv:</td>
            <td class="priv">
                $priv
            </td>
        </tr>
    </table>
EOD
    }

    sub HTMLend {
        print <<"EOD";

</body>
</html>
EOD
    }

    sub showHelp {
        my $help = <<"EOD";
perl paper_wallet.pl [ option... ] file...
  Commands and arguments:
    -date text          Use text as generation date
    -font fname         Display addresses and keys in CSS font fname
    -help               Print this message
    -offset n           Add n to the address numbers in the input file
    -perpage n          Print n addresses per page
    -prefix text        Prefix address labels with text
    -separator text     Show addresses as 4 character groups with separator text
    -size fsize         Display addresses with CSS font size fsize
    -title text         Use text as page title
    -weight wgt         Show addresses with CSS font weight wgt
EOD
        print($help);
        exit(0);
    }
